/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.sync.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.sync.v1.service.SyncStreamCreator;
import com.twilio.rest.sync.v1.service.SyncStreamDeleter;
import com.twilio.rest.sync.v1.service.SyncStreamFetcher;
import com.twilio.rest.sync.v1.service.SyncStreamReader;
import com.twilio.rest.sync.v1.service.SyncStreamUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SyncStream
extends Resource {
    private static final long serialVersionUID = 240146789601739L;
    private final String sid;
    private final String uniqueName;
    private final String accountSid;
    private final String serviceSid;
    private final URI url;
    private final Map<String, String> links;
    private final DateTime dateExpires;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String createdBy;

    public static SyncStreamFetcher fetcher(String pathServiceSid, String pathSid) {
        return new SyncStreamFetcher(pathServiceSid, pathSid);
    }

    public static SyncStreamDeleter deleter(String pathServiceSid, String pathSid) {
        return new SyncStreamDeleter(pathServiceSid, pathSid);
    }

    public static SyncStreamCreator creator(String pathServiceSid) {
        return new SyncStreamCreator(pathServiceSid);
    }

    public static SyncStreamUpdater updater(String pathServiceSid, String pathSid) {
        return new SyncStreamUpdater(pathServiceSid, pathSid);
    }

    public static SyncStreamReader reader(String pathServiceSid) {
        return new SyncStreamReader(pathServiceSid);
    }

    public static SyncStream fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (SyncStream)objectMapper.readValue(json, SyncStream.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static SyncStream fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (SyncStream)objectMapper.readValue(json, SyncStream.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private SyncStream(@JsonProperty(value="sid") String sid, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links, @JsonProperty(value="date_expires") String dateExpires, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="created_by") String createdBy) {
        this.sid = sid;
        this.uniqueName = uniqueName;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.url = url;
        this.links = links;
        this.dateExpires = DateConverter.iso8601DateTimeFromString(dateExpires);
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.createdBy = createdBy;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public final DateTime getDateExpires() {
        return this.dateExpires;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getCreatedBy() {
        return this.createdBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyncStream other = (SyncStream)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links) && Objects.equals(this.dateExpires, other.dateExpires) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.createdBy, other.createdBy);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.uniqueName, this.accountSid, this.serviceSid, this.url, this.links, this.dateExpires, this.dateCreated, this.dateUpdated, this.createdBy);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("uniqueName", (Object)this.uniqueName).add("accountSid", (Object)this.accountSid).add("serviceSid", (Object)this.serviceSid).add("url", (Object)this.url).add("links", this.links).add("dateExpires", (Object)this.dateExpires).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("createdBy", (Object)this.createdBy).toString();
    }
}

