/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.supersim.v1.NetworkAccessProfile;

public class NetworkAccessProfileReader
extends Reader<NetworkAccessProfile> {
    @Override
    public ResourceSet<NetworkAccessProfile> read(TwilioRestClient client) {
        return new ResourceSet<NetworkAccessProfile>(this, client, this.firstPage(client));
    }

    @Override
    public Page<NetworkAccessProfile> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.SUPERSIM.toString(), "/v1/NetworkAccessProfiles");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<NetworkAccessProfile> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<NetworkAccessProfile> nextPage(Page<NetworkAccessProfile> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.SUPERSIM.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<NetworkAccessProfile> previousPage(Page<NetworkAccessProfile> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.SUPERSIM.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<NetworkAccessProfile> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("NetworkAccessProfile read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("network_access_profiles", response.getContent(), NetworkAccessProfile.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

