/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v1.flow.execution;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.studio.v1.flow.execution.ExecutionContext;

public class ExecutionContextFetcher
extends Fetcher<ExecutionContext> {
    private final String pathFlowSid;
    private final String pathExecutionSid;

    public ExecutionContextFetcher(String pathFlowSid, String pathExecutionSid) {
        this.pathFlowSid = pathFlowSid;
        this.pathExecutionSid = pathExecutionSid;
    }

    @Override
    public ExecutionContext fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.STUDIO.toString(), "/v1/Flows/" + this.pathFlowSid + "/Executions/" + this.pathExecutionSid + "/Context");
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ExecutionContext fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return ExecutionContext.fromJson(response.getStream(), client.getObjectMapper());
    }
}

