/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.proxy.v1.service.session;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.proxy.v1.service.session.InteractionDeleter;
import com.twilio.rest.proxy.v1.service.session.InteractionFetcher;
import com.twilio.rest.proxy.v1.service.session.InteractionReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Interaction
extends Resource {
    private static final long serialVersionUID = 184706954085822L;
    private final String sid;
    private final String sessionSid;
    private final String serviceSid;
    private final String accountSid;
    private final String data;
    private final Type type;
    private final String inboundParticipantSid;
    private final String inboundResourceSid;
    private final ResourceStatus inboundResourceStatus;
    private final String inboundResourceType;
    private final URI inboundResourceUrl;
    private final String outboundParticipantSid;
    private final String outboundResourceSid;
    private final ResourceStatus outboundResourceStatus;
    private final String outboundResourceType;
    private final URI outboundResourceUrl;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;

    public static InteractionFetcher fetcher(String pathServiceSid, String pathSessionSid, String pathSid) {
        return new InteractionFetcher(pathServiceSid, pathSessionSid, pathSid);
    }

    public static InteractionReader reader(String pathServiceSid, String pathSessionSid) {
        return new InteractionReader(pathServiceSid, pathSessionSid);
    }

    public static InteractionDeleter deleter(String pathServiceSid, String pathSessionSid, String pathSid) {
        return new InteractionDeleter(pathServiceSid, pathSessionSid, pathSid);
    }

    public static Interaction fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Interaction)objectMapper.readValue(json, Interaction.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Interaction fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Interaction)objectMapper.readValue(json, Interaction.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Interaction(@JsonProperty(value="sid") String sid, @JsonProperty(value="session_sid") String sessionSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="data") String data, @JsonProperty(value="type") Type type, @JsonProperty(value="inbound_participant_sid") String inboundParticipantSid, @JsonProperty(value="inbound_resource_sid") String inboundResourceSid, @JsonProperty(value="inbound_resource_status") ResourceStatus inboundResourceStatus, @JsonProperty(value="inbound_resource_type") String inboundResourceType, @JsonProperty(value="inbound_resource_url") URI inboundResourceUrl, @JsonProperty(value="outbound_participant_sid") String outboundParticipantSid, @JsonProperty(value="outbound_resource_sid") String outboundResourceSid, @JsonProperty(value="outbound_resource_status") ResourceStatus outboundResourceStatus, @JsonProperty(value="outbound_resource_type") String outboundResourceType, @JsonProperty(value="outbound_resource_url") URI outboundResourceUrl, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.sessionSid = sessionSid;
        this.serviceSid = serviceSid;
        this.accountSid = accountSid;
        this.data = data;
        this.type = type;
        this.inboundParticipantSid = inboundParticipantSid;
        this.inboundResourceSid = inboundResourceSid;
        this.inboundResourceStatus = inboundResourceStatus;
        this.inboundResourceType = inboundResourceType;
        this.inboundResourceUrl = inboundResourceUrl;
        this.outboundParticipantSid = outboundParticipantSid;
        this.outboundResourceSid = outboundResourceSid;
        this.outboundResourceStatus = outboundResourceStatus;
        this.outboundResourceType = outboundResourceType;
        this.outboundResourceUrl = outboundResourceUrl;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getSessionSid() {
        return this.sessionSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getData() {
        return this.data;
    }

    public final Type getType() {
        return this.type;
    }

    public final String getInboundParticipantSid() {
        return this.inboundParticipantSid;
    }

    public final String getInboundResourceSid() {
        return this.inboundResourceSid;
    }

    public final ResourceStatus getInboundResourceStatus() {
        return this.inboundResourceStatus;
    }

    public final String getInboundResourceType() {
        return this.inboundResourceType;
    }

    public final URI getInboundResourceUrl() {
        return this.inboundResourceUrl;
    }

    public final String getOutboundParticipantSid() {
        return this.outboundParticipantSid;
    }

    public final String getOutboundResourceSid() {
        return this.outboundResourceSid;
    }

    public final ResourceStatus getOutboundResourceStatus() {
        return this.outboundResourceStatus;
    }

    public final String getOutboundResourceType() {
        return this.outboundResourceType;
    }

    public final URI getOutboundResourceUrl() {
        return this.outboundResourceUrl;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Interaction other = (Interaction)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.sessionSid, other.sessionSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.data, other.data) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.inboundParticipantSid, other.inboundParticipantSid) && Objects.equals(this.inboundResourceSid, other.inboundResourceSid) && Objects.equals((Object)this.inboundResourceStatus, (Object)other.inboundResourceStatus) && Objects.equals(this.inboundResourceType, other.inboundResourceType) && Objects.equals(this.inboundResourceUrl, other.inboundResourceUrl) && Objects.equals(this.outboundParticipantSid, other.outboundParticipantSid) && Objects.equals(this.outboundResourceSid, other.outboundResourceSid) && Objects.equals((Object)this.outboundResourceStatus, (Object)other.outboundResourceStatus) && Objects.equals(this.outboundResourceType, other.outboundResourceType) && Objects.equals(this.outboundResourceUrl, other.outboundResourceUrl) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.sessionSid, this.serviceSid, this.accountSid, this.data, this.type, this.inboundParticipantSid, this.inboundResourceSid, this.inboundResourceStatus, this.inboundResourceType, this.inboundResourceUrl, this.outboundParticipantSid, this.outboundResourceSid, this.outboundResourceStatus, this.outboundResourceType, this.outboundResourceUrl, this.dateCreated, this.dateUpdated, this.url});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("sessionSid", (Object)this.sessionSid).add("serviceSid", (Object)this.serviceSid).add("accountSid", (Object)this.accountSid).add("data", (Object)this.data).add("type", (Object)this.type).add("inboundParticipantSid", (Object)this.inboundParticipantSid).add("inboundResourceSid", (Object)this.inboundResourceSid).add("inboundResourceStatus", (Object)this.inboundResourceStatus).add("inboundResourceType", (Object)this.inboundResourceType).add("inboundResourceUrl", (Object)this.inboundResourceUrl).add("outboundParticipantSid", (Object)this.outboundParticipantSid).add("outboundResourceSid", (Object)this.outboundResourceSid).add("outboundResourceStatus", (Object)this.outboundResourceStatus).add("outboundResourceType", (Object)this.outboundResourceType).add("outboundResourceUrl", (Object)this.outboundResourceUrl).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("url", (Object)this.url).toString();
    }

    public static enum ResourceStatus {
        ACCEPTED("accepted"),
        ANSWERED("answered"),
        BUSY("busy"),
        CANCELED("canceled"),
        COMPLETED("completed"),
        DELETED("deleted"),
        DELIVERED("delivered"),
        DELIVERY_UNKNOWN("delivery-unknown"),
        FAILED("failed"),
        IN_PROGRESS("in-progress"),
        INITIATED("initiated"),
        NO_ANSWER("no-answer"),
        QUEUED("queued"),
        RECEIVED("received"),
        RECEIVING("receiving"),
        RINGING("ringing"),
        SCHEDULED("scheduled"),
        SENDING("sending"),
        SENT("sent"),
        UNDELIVERED("undelivered"),
        UNKNOWN("unknown");

        private final String value;

        private ResourceStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ResourceStatus forValue(String value) {
            return (ResourceStatus)Promoter.enumFromString((String)value, (Enum[])ResourceStatus.values());
        }
    }

    public static enum Type {
        MESSAGE("message"),
        VOICE("voice"),
        UNKNOWN("unknown");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Type forValue(String value) {
            return (Type)Promoter.enumFromString((String)value, (Enum[])Type.values());
        }
    }
}

