/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.pricing.v1.voice;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.CurrencyDeserializer;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.pricing.v1.voice.NumberFetcher;
import com.twilio.type.InboundCallPrice;
import com.twilio.type.OutboundCallPrice;
import com.twilio.type.PhoneNumber;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Currency;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Number
extends Resource {
    private static final long serialVersionUID = 198694876395979L;
    private final PhoneNumber number;
    private final String country;
    private final String isoCountry;
    private final OutboundCallPrice outboundCallPrice;
    private final InboundCallPrice inboundCallPrice;
    private final Currency priceUnit;
    private final URI url;

    public static NumberFetcher fetcher(PhoneNumber pathNumber) {
        return new NumberFetcher(pathNumber);
    }

    public static Number fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Number)objectMapper.readValue(json, Number.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Number fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Number)objectMapper.readValue(json, Number.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Number(@JsonProperty(value="number") PhoneNumber number, @JsonProperty(value="country") String country, @JsonProperty(value="iso_country") String isoCountry, @JsonProperty(value="outbound_call_price") OutboundCallPrice outboundCallPrice, @JsonProperty(value="inbound_call_price") InboundCallPrice inboundCallPrice, @JsonProperty(value="price_unit") @JsonDeserialize(using=CurrencyDeserializer.class) Currency priceUnit, @JsonProperty(value="url") URI url) {
        this.number = number;
        this.country = country;
        this.isoCountry = isoCountry;
        this.outboundCallPrice = outboundCallPrice;
        this.inboundCallPrice = inboundCallPrice;
        this.priceUnit = priceUnit;
        this.url = url;
    }

    public final PhoneNumber getNumber() {
        return this.number;
    }

    public final String getCountry() {
        return this.country;
    }

    public final String getIsoCountry() {
        return this.isoCountry;
    }

    public final OutboundCallPrice getOutboundCallPrice() {
        return this.outboundCallPrice;
    }

    public final InboundCallPrice getInboundCallPrice() {
        return this.inboundCallPrice;
    }

    public final Currency getPriceUnit() {
        return this.priceUnit;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Number other = (Number)o;
        return Objects.equals(this.number, other.number) && Objects.equals(this.country, other.country) && Objects.equals(this.isoCountry, other.isoCountry) && Objects.equals(this.outboundCallPrice, other.outboundCallPrice) && Objects.equals(this.inboundCallPrice, other.inboundCallPrice) && Objects.equals(this.priceUnit, other.priceUnit) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.number, this.country, this.isoCountry, this.outboundCallPrice, this.inboundCallPrice, this.priceUnit, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("number", (Object)this.number).add("country", (Object)this.country).add("isoCountry", (Object)this.isoCountry).add("outboundCallPrice", (Object)this.outboundCallPrice).add("inboundCallPrice", (Object)this.inboundCallPrice).add("priceUnit", (Object)this.priceUnit).add("url", (Object)this.url).toString();
    }
}

