/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.wireless.sim;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.wireless.sim.UsageFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Usage
extends Resource {
    private static final long serialVersionUID = 16456693522984L;
    private final String simSid;
    private final String simUniqueName;
    private final String accountSid;
    private final Map<String, Object> period;
    private final Map<String, Object> commandsUsage;
    private final Map<String, Object> commandsCosts;
    private final Map<String, Object> dataUsage;
    private final Map<String, Object> dataCosts;
    private final URI url;

    public static UsageFetcher fetcher(String pathSimSid) {
        return new UsageFetcher(pathSimSid);
    }

    public static Usage fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Usage)objectMapper.readValue(json, Usage.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Usage fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Usage)objectMapper.readValue(json, Usage.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Usage(@JsonProperty(value="sim_sid") String simSid, @JsonProperty(value="sim_unique_name") String simUniqueName, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="period") Map<String, Object> period, @JsonProperty(value="commands_usage") Map<String, Object> commandsUsage, @JsonProperty(value="commands_costs") Map<String, Object> commandsCosts, @JsonProperty(value="data_usage") Map<String, Object> dataUsage, @JsonProperty(value="data_costs") Map<String, Object> dataCosts, @JsonProperty(value="url") URI url) {
        this.simSid = simSid;
        this.simUniqueName = simUniqueName;
        this.accountSid = accountSid;
        this.period = period;
        this.commandsUsage = commandsUsage;
        this.commandsCosts = commandsCosts;
        this.dataUsage = dataUsage;
        this.dataCosts = dataCosts;
        this.url = url;
    }

    public final String getSimSid() {
        return this.simSid;
    }

    public final String getSimUniqueName() {
        return this.simUniqueName;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Map<String, Object> getPeriod() {
        return this.period;
    }

    public final Map<String, Object> getCommandsUsage() {
        return this.commandsUsage;
    }

    public final Map<String, Object> getCommandsCosts() {
        return this.commandsCosts;
    }

    public final Map<String, Object> getDataUsage() {
        return this.dataUsage;
    }

    public final Map<String, Object> getDataCosts() {
        return this.dataCosts;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Usage other = (Usage)o;
        return Objects.equals(this.simSid, other.simSid) && Objects.equals(this.simUniqueName, other.simUniqueName) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.period, other.period) && Objects.equals(this.commandsUsage, other.commandsUsage) && Objects.equals(this.commandsCosts, other.commandsCosts) && Objects.equals(this.dataUsage, other.dataUsage) && Objects.equals(this.dataCosts, other.dataCosts) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.simSid, this.simUniqueName, this.accountSid, this.period, this.commandsUsage, this.commandsCosts, this.dataUsage, this.dataCosts, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("simSid", (Object)this.simSid).add("simUniqueName", (Object)this.simUniqueName).add("accountSid", (Object)this.accountSid).add("period", this.period).add("commandsUsage", this.commandsUsage).add("commandsCosts", this.commandsCosts).add("dataUsage", this.dataUsage).add("dataCosts", this.dataCosts).add("url", (Object)this.url).toString();
    }
}

