/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.trustedComms.business.brand.brandedchannel;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.trustedComms.business.brand.brandedchannel.Channel;

public class ChannelCreator
extends Creator<Channel> {
    private final String pathBusinessSid;
    private final String pathBrandSid;
    private final String pathBrandedChannelSid;
    private final String phoneNumberSid;

    public ChannelCreator(String pathBusinessSid, String pathBrandSid, String pathBrandedChannelSid, String phoneNumberSid) {
        this.pathBusinessSid = pathBusinessSid;
        this.pathBrandSid = pathBrandSid;
        this.pathBrandedChannelSid = pathBrandedChannelSid;
        this.phoneNumberSid = phoneNumberSid;
    }

    @Override
    public Channel create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), "/TrustedComms/Businesses/" + this.pathBusinessSid + "/Brands/" + this.pathBrandSid + "/BrandedChannels/" + this.pathBrandedChannelSid + "/Channels");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Channel creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Channel.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.phoneNumberSid != null) {
            request.addPostParam("PhoneNumberSid", this.phoneNumberSid);
        }
    }
}

