/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.trustedComms.business.brand;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.trustedComms.business.brand.BrandedChannel;

public class BrandedChannelFetcher
extends Fetcher<BrandedChannel> {
    private final String pathBusinessSid;
    private final String pathBrandSid;
    private final String pathSid;

    public BrandedChannelFetcher(String pathBusinessSid, String pathBrandSid, String pathSid) {
        this.pathBusinessSid = pathBusinessSid;
        this.pathBrandSid = pathBrandSid;
        this.pathSid = pathSid;
    }

    @Override
    public BrandedChannel fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.PREVIEW.toString(), "/TrustedComms/Businesses/" + this.pathBusinessSid + "/Brands/" + this.pathBrandSid + "/BrandedChannels/" + this.pathSid + "");
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("BrandedChannel fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return BrandedChannel.fromJson(response.getStream(), client.getObjectMapper());
    }
}

