/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.hostedNumbers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.hostedNumbers.HostedNumberOrderCreator;
import com.twilio.rest.preview.hostedNumbers.HostedNumberOrderDeleter;
import com.twilio.rest.preview.hostedNumbers.HostedNumberOrderFetcher;
import com.twilio.rest.preview.hostedNumbers.HostedNumberOrderReader;
import com.twilio.rest.preview.hostedNumbers.HostedNumberOrderUpdater;
import com.twilio.type.PhoneNumber;
import com.twilio.type.PhoneNumberCapabilities;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HostedNumberOrder
extends Resource {
    private static final long serialVersionUID = 200143237925863L;
    private final String sid;
    private final String accountSid;
    private final String incomingPhoneNumberSid;
    private final String addressSid;
    private final String signingDocumentSid;
    private final PhoneNumber phoneNumber;
    private final PhoneNumberCapabilities capabilities;
    private final String friendlyName;
    private final String uniqueName;
    private final Status status;
    private final String failureReason;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final Integer verificationAttempts;
    private final String email;
    private final List<String> ccEmails;
    private final URI url;
    private final VerificationType verificationType;
    private final String verificationDocumentSid;
    private final String extension;
    private final Integer callDelay;
    private final String verificationCode;
    private final List<String> verificationCallSids;

    public static HostedNumberOrderFetcher fetcher(String pathSid) {
        return new HostedNumberOrderFetcher(pathSid);
    }

    public static HostedNumberOrderDeleter deleter(String pathSid) {
        return new HostedNumberOrderDeleter(pathSid);
    }

    public static HostedNumberOrderUpdater updater(String pathSid) {
        return new HostedNumberOrderUpdater(pathSid);
    }

    public static HostedNumberOrderReader reader() {
        return new HostedNumberOrderReader();
    }

    public static HostedNumberOrderCreator creator(PhoneNumber phoneNumber, Boolean smsCapability) {
        return new HostedNumberOrderCreator(phoneNumber, smsCapability);
    }

    public static HostedNumberOrder fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (HostedNumberOrder)objectMapper.readValue(json, HostedNumberOrder.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static HostedNumberOrder fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (HostedNumberOrder)objectMapper.readValue(json, HostedNumberOrder.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private HostedNumberOrder(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="incoming_phone_number_sid") String incomingPhoneNumberSid, @JsonProperty(value="address_sid") String addressSid, @JsonProperty(value="signing_document_sid") String signingDocumentSid, @JsonProperty(value="phone_number") PhoneNumber phoneNumber, @JsonProperty(value="capabilities") PhoneNumberCapabilities capabilities, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="status") Status status, @JsonProperty(value="failure_reason") String failureReason, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="verification_attempts") Integer verificationAttempts, @JsonProperty(value="email") String email, @JsonProperty(value="cc_emails") List<String> ccEmails, @JsonProperty(value="url") URI url, @JsonProperty(value="verification_type") VerificationType verificationType, @JsonProperty(value="verification_document_sid") String verificationDocumentSid, @JsonProperty(value="extension") String extension, @JsonProperty(value="call_delay") Integer callDelay, @JsonProperty(value="verification_code") String verificationCode, @JsonProperty(value="verification_call_sids") List<String> verificationCallSids) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.incomingPhoneNumberSid = incomingPhoneNumberSid;
        this.addressSid = addressSid;
        this.signingDocumentSid = signingDocumentSid;
        this.phoneNumber = phoneNumber;
        this.capabilities = capabilities;
        this.friendlyName = friendlyName;
        this.uniqueName = uniqueName;
        this.status = status;
        this.failureReason = failureReason;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.verificationAttempts = verificationAttempts;
        this.email = email;
        this.ccEmails = ccEmails;
        this.url = url;
        this.verificationType = verificationType;
        this.verificationDocumentSid = verificationDocumentSid;
        this.extension = extension;
        this.callDelay = callDelay;
        this.verificationCode = verificationCode;
        this.verificationCallSids = verificationCallSids;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getIncomingPhoneNumberSid() {
        return this.incomingPhoneNumberSid;
    }

    public final String getAddressSid() {
        return this.addressSid;
    }

    public final String getSigningDocumentSid() {
        return this.signingDocumentSid;
    }

    public final PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    public final PhoneNumberCapabilities getCapabilities() {
        return this.capabilities;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final String getFailureReason() {
        return this.failureReason;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final Integer getVerificationAttempts() {
        return this.verificationAttempts;
    }

    public final String getEmail() {
        return this.email;
    }

    public final List<String> getCcEmails() {
        return this.ccEmails;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final VerificationType getVerificationType() {
        return this.verificationType;
    }

    public final String getVerificationDocumentSid() {
        return this.verificationDocumentSid;
    }

    public final String getExtension() {
        return this.extension;
    }

    public final Integer getCallDelay() {
        return this.callDelay;
    }

    public final String getVerificationCode() {
        return this.verificationCode;
    }

    public final List<String> getVerificationCallSids() {
        return this.verificationCallSids;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostedNumberOrder other = (HostedNumberOrder)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.incomingPhoneNumberSid, other.incomingPhoneNumberSid) && Objects.equals(this.addressSid, other.addressSid) && Objects.equals(this.signingDocumentSid, other.signingDocumentSid) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.capabilities, other.capabilities) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.failureReason, other.failureReason) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.verificationAttempts, other.verificationAttempts) && Objects.equals(this.email, other.email) && Objects.equals(this.ccEmails, other.ccEmails) && Objects.equals(this.url, other.url) && Objects.equals((Object)this.verificationType, (Object)other.verificationType) && Objects.equals(this.verificationDocumentSid, other.verificationDocumentSid) && Objects.equals(this.extension, other.extension) && Objects.equals(this.callDelay, other.callDelay) && Objects.equals(this.verificationCode, other.verificationCode) && Objects.equals(this.verificationCallSids, other.verificationCallSids);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.incomingPhoneNumberSid, this.addressSid, this.signingDocumentSid, this.phoneNumber, this.capabilities, this.friendlyName, this.uniqueName, this.status, this.failureReason, this.dateCreated, this.dateUpdated, this.verificationAttempts, this.email, this.ccEmails, this.url, this.verificationType, this.verificationDocumentSid, this.extension, this.callDelay, this.verificationCode, this.verificationCallSids});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("incomingPhoneNumberSid", (Object)this.incomingPhoneNumberSid).add("addressSid", (Object)this.addressSid).add("signingDocumentSid", (Object)this.signingDocumentSid).add("phoneNumber", (Object)this.phoneNumber).add("capabilities", (Object)this.capabilities).add("friendlyName", (Object)this.friendlyName).add("uniqueName", (Object)this.uniqueName).add("status", (Object)this.status).add("failureReason", (Object)this.failureReason).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("verificationAttempts", (Object)this.verificationAttempts).add("email", (Object)this.email).add("ccEmails", this.ccEmails).add("url", (Object)this.url).add("verificationType", (Object)this.verificationType).add("verificationDocumentSid", (Object)this.verificationDocumentSid).add("extension", (Object)this.extension).add("callDelay", (Object)this.callDelay).add("verificationCode", (Object)this.verificationCode).add("verificationCallSids", this.verificationCallSids).toString();
    }

    public static enum VerificationType {
        PHONE_CALL("phone-call"),
        PHONE_BILL("phone-bill");

        private final String value;

        private VerificationType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static VerificationType forValue(String value) {
            return (VerificationType)Promoter.enumFromString((String)value, (Enum[])VerificationType.values());
        }
    }

    public static enum Status {
        RECEIVED("received"),
        PENDING_VERIFICATION("pending-verification"),
        VERIFIED("verified"),
        PENDING_LOA("pending-loa"),
        CARRIER_PROCESSING("carrier-processing"),
        TESTING("testing"),
        COMPLETED("completed"),
        FAILED("failed"),
        ACTION_REQUIRED("action-required");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

