/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.events.v1.schema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.events.v1.schema.VersionFetcher;
import com.twilio.rest.events.v1.schema.VersionReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Version
extends Resource {
    private static final long serialVersionUID = 53241776075196L;
    private final String id;
    private final Integer schemaVersion;
    private final DateTime dateCreated;
    private final URI url;
    private final URI raw;

    public static VersionReader reader(String pathId) {
        return new VersionReader(pathId);
    }

    public static VersionFetcher fetcher(String pathId, Integer pathSchemaVersion) {
        return new VersionFetcher(pathId, pathSchemaVersion);
    }

    public static Version fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Version)objectMapper.readValue(json, Version.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Version fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Version)objectMapper.readValue(json, Version.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Version(@JsonProperty(value="id") String id, @JsonProperty(value="schema_version") Integer schemaVersion, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="url") URI url, @JsonProperty(value="raw") URI raw) {
        this.id = id;
        this.schemaVersion = schemaVersion;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.url = url;
        this.raw = raw;
    }

    public final String getId() {
        return this.id;
    }

    public final Integer getSchemaVersion() {
        return this.schemaVersion;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final URI getRaw() {
        return this.raw;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version other = (Version)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.schemaVersion, other.schemaVersion) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.url, other.url) && Objects.equals(this.raw, other.raw);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.schemaVersion, this.dateCreated, this.url, this.raw);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("schemaVersion", (Object)this.schemaVersion).add("dateCreated", (Object)this.dateCreated).add("url", (Object)this.url).add("raw", (Object)this.raw).toString();
    }
}

