/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.events.v1;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.events.v1.EventType;

public class EventTypeFetcher
extends Fetcher<EventType> {
    private final String pathType;

    public EventTypeFetcher(String pathType) {
        this.pathType = pathType;
    }

    @Override
    public EventType fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.EVENTS.toString(), "/v1/Types/" + this.pathType + "");
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("EventType fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return EventType.fromJson(response.getStream(), client.getObjectMapper());
    }
}

