/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.Role;
import java.util.List;

public class RoleUpdater
extends Updater<Role> {
    private final String pathSid;
    private final List<String> permission;

    public RoleUpdater(String pathSid, List<String> permission) {
        this.pathSid = pathSid;
        this.permission = permission;
    }

    @Override
    public Role update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.CONVERSATIONS.toString(), "/v1/Roles/" + this.pathSid + "");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Role update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Role.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.permission != null) {
            for (String prop : this.permission) {
                request.addPostParam("Permission", prop);
            }
        }
    }
}

