/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.chat.v2.service;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.chat.v2.service.Channel;
import org.joda.time.DateTime;

public class ChannelCreator
extends Creator<Channel> {
    private final String pathServiceSid;
    private String friendlyName;
    private String uniqueName;
    private String attributes;
    private Channel.ChannelType type;
    private DateTime dateCreated;
    private DateTime dateUpdated;
    private String createdBy;
    private Channel.WebhookEnabledType xTwilioWebhookEnabled;

    public ChannelCreator(String pathServiceSid) {
        this.pathServiceSid = pathServiceSid;
    }

    public ChannelCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ChannelCreator setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public ChannelCreator setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    public ChannelCreator setType(Channel.ChannelType type) {
        this.type = type;
        return this;
    }

    public ChannelCreator setDateCreated(DateTime dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    public ChannelCreator setDateUpdated(DateTime dateUpdated) {
        this.dateUpdated = dateUpdated;
        return this;
    }

    public ChannelCreator setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    public ChannelCreator setXTwilioWebhookEnabled(Channel.WebhookEnabledType xTwilioWebhookEnabled) {
        this.xTwilioWebhookEnabled = xTwilioWebhookEnabled;
        return this;
    }

    @Override
    public Channel create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.CHAT.toString(), "/v2/Services/" + this.pathServiceSid + "/Channels");
        this.addPostParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Channel creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Channel.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addHeaderParams(Request request) {
        if (this.xTwilioWebhookEnabled != null) {
            request.addHeaderParam("X-Twilio-Webhook-Enabled", this.xTwilioWebhookEnabled.toString());
        }
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
        if (this.type != null) {
            request.addPostParam("Type", this.type.toString());
        }
        if (this.dateCreated != null) {
            request.addPostParam("DateCreated", this.dateCreated.toString());
        }
        if (this.dateUpdated != null) {
            request.addPostParam("DateUpdated", this.dateUpdated.toString());
        }
        if (this.createdBy != null) {
            request.addPostParam("CreatedBy", this.createdBy);
        }
    }
}

