/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.autopilot.v1.assistant.task;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.autopilot.v1.assistant.task.Sample;

public class SampleUpdater
extends Updater<Sample> {
    private final String pathAssistantSid;
    private final String pathTaskSid;
    private final String pathSid;
    private String language;
    private String taggedText;
    private String sourceChannel;

    public SampleUpdater(String pathAssistantSid, String pathTaskSid, String pathSid) {
        this.pathAssistantSid = pathAssistantSid;
        this.pathTaskSid = pathTaskSid;
        this.pathSid = pathSid;
    }

    public SampleUpdater setLanguage(String language) {
        this.language = language;
        return this;
    }

    public SampleUpdater setTaggedText(String taggedText) {
        this.taggedText = taggedText;
        return this;
    }

    public SampleUpdater setSourceChannel(String sourceChannel) {
        this.sourceChannel = sourceChannel;
        return this;
    }

    @Override
    public Sample update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.AUTOPILOT.toString(), "/v1/Assistants/" + this.pathAssistantSid + "/Tasks/" + this.pathTaskSid + "/Samples/" + this.pathSid + "");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Sample update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Sample.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.language != null) {
            request.addPostParam("Language", this.language);
        }
        if (this.taggedText != null) {
            request.addPostParam("TaggedText", this.taggedText);
        }
        if (this.sourceChannel != null) {
            request.addPostParam("SourceChannel", this.sourceChannel);
        }
    }
}

