/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.autopilot.v1.assistant;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.autopilot.v1.assistant.Webhook;
import java.net.URI;

public class WebhookUpdater
extends Updater<Webhook> {
    private final String pathAssistantSid;
    private final String pathSid;
    private String uniqueName;
    private String events;
    private URI webhookUrl;
    private String webhookMethod;

    public WebhookUpdater(String pathAssistantSid, String pathSid) {
        this.pathAssistantSid = pathAssistantSid;
        this.pathSid = pathSid;
    }

    public WebhookUpdater setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public WebhookUpdater setEvents(String events) {
        this.events = events;
        return this;
    }

    public WebhookUpdater setWebhookUrl(URI webhookUrl) {
        this.webhookUrl = webhookUrl;
        return this;
    }

    public WebhookUpdater setWebhookUrl(String webhookUrl) {
        return this.setWebhookUrl(Promoter.uriFromString(webhookUrl));
    }

    public WebhookUpdater setWebhookMethod(String webhookMethod) {
        this.webhookMethod = webhookMethod;
        return this;
    }

    @Override
    public Webhook update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.AUTOPILOT.toString(), "/v1/Assistants/" + this.pathAssistantSid + "/Webhooks/" + this.pathSid + "");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Webhook update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Webhook.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.events != null) {
            request.addPostParam("Events", this.events);
        }
        if (this.webhookUrl != null) {
            request.addPostParam("WebhookUrl", this.webhookUrl.toString());
        }
        if (this.webhookMethod != null) {
            request.addPostParam("WebhookMethod", this.webhookMethod);
        }
    }
}

