/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.sip.domain.authtypes.authtypecalls;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.sip.domain.authtypes.authtypecalls.AuthCallsIpAccessControlListMappingCreator;
import com.twilio.rest.api.v2010.account.sip.domain.authtypes.authtypecalls.AuthCallsIpAccessControlListMappingDeleter;
import com.twilio.rest.api.v2010.account.sip.domain.authtypes.authtypecalls.AuthCallsIpAccessControlListMappingFetcher;
import com.twilio.rest.api.v2010.account.sip.domain.authtypes.authtypecalls.AuthCallsIpAccessControlListMappingReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AuthCallsIpAccessControlListMapping
extends Resource {
    private static final long serialVersionUID = 271887954844194L;
    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String friendlyName;
    private final String sid;

    public static AuthCallsIpAccessControlListMappingCreator creator(String pathAccountSid, String pathDomainSid, String ipAccessControlListSid) {
        return new AuthCallsIpAccessControlListMappingCreator(pathAccountSid, pathDomainSid, ipAccessControlListSid);
    }

    public static AuthCallsIpAccessControlListMappingCreator creator(String pathDomainSid, String ipAccessControlListSid) {
        return new AuthCallsIpAccessControlListMappingCreator(pathDomainSid, ipAccessControlListSid);
    }

    public static AuthCallsIpAccessControlListMappingReader reader(String pathAccountSid, String pathDomainSid) {
        return new AuthCallsIpAccessControlListMappingReader(pathAccountSid, pathDomainSid);
    }

    public static AuthCallsIpAccessControlListMappingReader reader(String pathDomainSid) {
        return new AuthCallsIpAccessControlListMappingReader(pathDomainSid);
    }

    public static AuthCallsIpAccessControlListMappingFetcher fetcher(String pathAccountSid, String pathDomainSid, String pathSid) {
        return new AuthCallsIpAccessControlListMappingFetcher(pathAccountSid, pathDomainSid, pathSid);
    }

    public static AuthCallsIpAccessControlListMappingFetcher fetcher(String pathDomainSid, String pathSid) {
        return new AuthCallsIpAccessControlListMappingFetcher(pathDomainSid, pathSid);
    }

    public static AuthCallsIpAccessControlListMappingDeleter deleter(String pathAccountSid, String pathDomainSid, String pathSid) {
        return new AuthCallsIpAccessControlListMappingDeleter(pathAccountSid, pathDomainSid, pathSid);
    }

    public static AuthCallsIpAccessControlListMappingDeleter deleter(String pathDomainSid, String pathSid) {
        return new AuthCallsIpAccessControlListMappingDeleter(pathDomainSid, pathSid);
    }

    public static AuthCallsIpAccessControlListMapping fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (AuthCallsIpAccessControlListMapping)objectMapper.readValue(json, AuthCallsIpAccessControlListMapping.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static AuthCallsIpAccessControlListMapping fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (AuthCallsIpAccessControlListMapping)objectMapper.readValue(json, AuthCallsIpAccessControlListMapping.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private AuthCallsIpAccessControlListMapping(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="sid") String sid) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.sid = sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getSid() {
        return this.sid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthCallsIpAccessControlListMapping other = (AuthCallsIpAccessControlListMapping)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.sid, other.sid);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.dateCreated, this.dateUpdated, this.friendlyName, this.sid);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("friendlyName", (Object)this.friendlyName).add("sid", (Object)this.sid).toString();
    }
}

