/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.recording;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.recording.AddOnResult;

public class AddOnResultFetcher
extends Fetcher<AddOnResult> {
    private String pathAccountSid;
    private final String pathReferenceSid;
    private final String pathSid;

    public AddOnResultFetcher(String pathReferenceSid, String pathSid) {
        this.pathReferenceSid = pathReferenceSid;
        this.pathSid = pathSid;
    }

    public AddOnResultFetcher(String pathAccountSid, String pathReferenceSid, String pathSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathReferenceSid = pathReferenceSid;
        this.pathSid = pathSid;
    }

    @Override
    public AddOnResult fetch(TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathAccountSid + "/Recordings/" + this.pathReferenceSid + "/AddOnResults/" + this.pathSid + ".json");
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AddOnResult fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return AddOnResult.fromJson(response.getStream(), client.getObjectMapper());
    }
}

