/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.voice.v1;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.voice.v1.ConnectionPolicy;

public class ConnectionPolicyUpdater
extends Updater<ConnectionPolicy> {
    private final String pathSid;
    private String friendlyName;

    public ConnectionPolicyUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public ConnectionPolicyUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    @Override
    public ConnectionPolicy update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.VOICE.toString(), "/v1/ConnectionPolicies/" + this.pathSid + "");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ConnectionPolicy update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return ConnectionPolicy.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
    }
}

