/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1.room.participant;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.video.v1.room.participant.SubscribedTrack;

public class SubscribedTrackReader
extends Reader<SubscribedTrack> {
    private final String pathRoomSid;
    private final String pathParticipantSid;

    public SubscribedTrackReader(String pathRoomSid, String pathParticipantSid) {
        this.pathRoomSid = pathRoomSid;
        this.pathParticipantSid = pathParticipantSid;
    }

    @Override
    public ResourceSet<SubscribedTrack> read(TwilioRestClient client) {
        return new ResourceSet<SubscribedTrack>(this, client, this.firstPage(client));
    }

    @Override
    public Page<SubscribedTrack> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.VIDEO.toString(), "/v1/Rooms/" + this.pathRoomSid + "/Participants/" + this.pathParticipantSid + "/SubscribedTracks");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SubscribedTrack> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SubscribedTrack> nextPage(Page<SubscribedTrack> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.VIDEO.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SubscribedTrack> previousPage(Page<SubscribedTrack> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.VIDEO.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<SubscribedTrack> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SubscribedTrack read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("subscribed_tracks", response.getContent(), SubscribedTrack.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

