/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.verify.v2.ServiceCreator;
import com.twilio.rest.verify.v2.ServiceDeleter;
import com.twilio.rest.verify.v2.ServiceFetcher;
import com.twilio.rest.verify.v2.ServiceReader;
import com.twilio.rest.verify.v2.ServiceUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Service
extends Resource {
    private static final long serialVersionUID = 64044796018507L;
    private final String sid;
    private final String accountSid;
    private final String friendlyName;
    private final Integer codeLength;
    private final Boolean lookupEnabled;
    private final Boolean psd2Enabled;
    private final Boolean skipSmsToLandlines;
    private final Boolean dtmfInputRequired;
    private final String ttsName;
    private final Boolean doNotShareWarningEnabled;
    private final Boolean customCodeEnabled;
    private final Map<String, Object> push;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;
    private final Map<String, String> links;

    public static ServiceCreator creator(String friendlyName) {
        return new ServiceCreator(friendlyName);
    }

    public static ServiceFetcher fetcher(String pathSid) {
        return new ServiceFetcher(pathSid);
    }

    public static ServiceDeleter deleter(String pathSid) {
        return new ServiceDeleter(pathSid);
    }

    public static ServiceReader reader() {
        return new ServiceReader();
    }

    public static ServiceUpdater updater(String pathSid) {
        return new ServiceUpdater(pathSid);
    }

    public static Service fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Service)objectMapper.readValue(json, Service.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Service fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Service)objectMapper.readValue(json, Service.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Service(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="code_length") Integer codeLength, @JsonProperty(value="lookup_enabled") Boolean lookupEnabled, @JsonProperty(value="psd2_enabled") Boolean psd2Enabled, @JsonProperty(value="skip_sms_to_landlines") Boolean skipSmsToLandlines, @JsonProperty(value="dtmf_input_required") Boolean dtmfInputRequired, @JsonProperty(value="tts_name") String ttsName, @JsonProperty(value="do_not_share_warning_enabled") Boolean doNotShareWarningEnabled, @JsonProperty(value="custom_code_enabled") Boolean customCodeEnabled, @JsonProperty(value="push") Map<String, Object> push, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.codeLength = codeLength;
        this.lookupEnabled = lookupEnabled;
        this.psd2Enabled = psd2Enabled;
        this.skipSmsToLandlines = skipSmsToLandlines;
        this.dtmfInputRequired = dtmfInputRequired;
        this.ttsName = ttsName;
        this.doNotShareWarningEnabled = doNotShareWarningEnabled;
        this.customCodeEnabled = customCodeEnabled;
        this.push = push;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final Integer getCodeLength() {
        return this.codeLength;
    }

    public final Boolean getLookupEnabled() {
        return this.lookupEnabled;
    }

    public final Boolean getPsd2Enabled() {
        return this.psd2Enabled;
    }

    public final Boolean getSkipSmsToLandlines() {
        return this.skipSmsToLandlines;
    }

    public final Boolean getDtmfInputRequired() {
        return this.dtmfInputRequired;
    }

    public final String getTtsName() {
        return this.ttsName;
    }

    public final Boolean getDoNotShareWarningEnabled() {
        return this.doNotShareWarningEnabled;
    }

    public final Boolean getCustomCodeEnabled() {
        return this.customCodeEnabled;
    }

    public final Map<String, Object> getPush() {
        return this.push;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Service other = (Service)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.codeLength, other.codeLength) && Objects.equals(this.lookupEnabled, other.lookupEnabled) && Objects.equals(this.psd2Enabled, other.psd2Enabled) && Objects.equals(this.skipSmsToLandlines, other.skipSmsToLandlines) && Objects.equals(this.dtmfInputRequired, other.dtmfInputRequired) && Objects.equals(this.ttsName, other.ttsName) && Objects.equals(this.doNotShareWarningEnabled, other.doNotShareWarningEnabled) && Objects.equals(this.customCodeEnabled, other.customCodeEnabled) && Objects.equals(this.push, other.push) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.friendlyName, this.codeLength, this.lookupEnabled, this.psd2Enabled, this.skipSmsToLandlines, this.dtmfInputRequired, this.ttsName, this.doNotShareWarningEnabled, this.customCodeEnabled, this.push, this.dateCreated, this.dateUpdated, this.url, this.links);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("friendlyName", (Object)this.friendlyName).add("codeLength", (Object)this.codeLength).add("lookupEnabled", (Object)this.lookupEnabled).add("psd2Enabled", (Object)this.psd2Enabled).add("skipSmsToLandlines", (Object)this.skipSmsToLandlines).add("dtmfInputRequired", (Object)this.dtmfInputRequired).add("ttsName", (Object)this.ttsName).add("doNotShareWarningEnabled", (Object)this.doNotShareWarningEnabled).add("customCodeEnabled", (Object)this.customCodeEnabled).add("push", this.push).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("url", (Object)this.url).add("links", this.links).toString();
    }
}

