/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trunking.v1.trunk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.trunking.v1.trunk.RecordingFetcher;
import com.twilio.rest.trunking.v1.trunk.RecordingUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Recording
extends Resource {
    private static final long serialVersionUID = 156418505978006L;
    private final RecordingMode mode;
    private final RecordingTrim trim;
    private final URI url;
    private final String trunkSid;

    public static RecordingFetcher fetcher(String pathTrunkSid) {
        return new RecordingFetcher(pathTrunkSid);
    }

    public static RecordingUpdater updater(String pathTrunkSid) {
        return new RecordingUpdater(pathTrunkSid);
    }

    public static Recording fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Recording)objectMapper.readValue(json, Recording.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Recording fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Recording)objectMapper.readValue(json, Recording.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Recording(@JsonProperty(value="mode") RecordingMode mode, @JsonProperty(value="trim") RecordingTrim trim, @JsonProperty(value="url") URI url, @JsonProperty(value="trunk_sid") String trunkSid) {
        this.mode = mode;
        this.trim = trim;
        this.url = url;
        this.trunkSid = trunkSid;
    }

    public final RecordingMode getMode() {
        return this.mode;
    }

    public final RecordingTrim getTrim() {
        return this.trim;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final String getTrunkSid() {
        return this.trunkSid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recording other = (Recording)o;
        return Objects.equals((Object)this.mode, (Object)other.mode) && Objects.equals((Object)this.trim, (Object)other.trim) && Objects.equals(this.url, other.url) && Objects.equals(this.trunkSid, other.trunkSid);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.trim, this.url, this.trunkSid});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mode", (Object)this.mode).add("trim", (Object)this.trim).add("url", (Object)this.url).add("trunkSid", (Object)this.trunkSid).toString();
    }

    public static enum RecordingTrim {
        TRIM_SILENCE("trim-silence"),
        DO_NOT_TRIM("do-not-trim");

        private final String value;

        private RecordingTrim(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static RecordingTrim forValue(String value) {
            return (RecordingTrim)Promoter.enumFromString((String)value, (Enum[])RecordingTrim.values());
        }
    }

    public static enum RecordingMode {
        DO_NOT_RECORD("do-not-record"),
        RECORD_FROM_RINGING("record-from-ringing"),
        RECORD_FROM_ANSWER("record-from-answer"),
        RECORD_FROM_RINGING_DUAL("record-from-ringing-dual"),
        RECORD_FROM_ANSWER_DUAL("record-from-answer-dual");

        private final String value;

        private RecordingMode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static RecordingMode forValue(String value) {
            return (RecordingMode)Promoter.enumFromString((String)value, (Enum[])RecordingMode.values());
        }
    }
}

