/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.sync.v1.service;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.sync.v1.service.SyncMap;

public class SyncMapReader
extends Reader<SyncMap> {
    private final String pathServiceSid;

    public SyncMapReader(String pathServiceSid) {
        this.pathServiceSid = pathServiceSid;
    }

    @Override
    public ResourceSet<SyncMap> read(TwilioRestClient client) {
        return new ResourceSet<SyncMap>(this, client, this.firstPage(client));
    }

    @Override
    public Page<SyncMap> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.SYNC.toString(), "/v1/Services/" + this.pathServiceSid + "/Maps");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SyncMap> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SyncMap> nextPage(Page<SyncMap> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.SYNC.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SyncMap> previousPage(Page<SyncMap> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.SYNC.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<SyncMap> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SyncMap read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("maps", response.getContent(), SyncMap.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

