/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.serverless.v1.service.environment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.serverless.v1.service.environment.DeploymentCreator;
import com.twilio.rest.serverless.v1.service.environment.DeploymentFetcher;
import com.twilio.rest.serverless.v1.service.environment.DeploymentReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Deployment
extends Resource {
    private static final long serialVersionUID = 221470253748944L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final String environmentSid;
    private final String buildSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;

    public static DeploymentReader reader(String pathServiceSid, String pathEnvironmentSid) {
        return new DeploymentReader(pathServiceSid, pathEnvironmentSid);
    }

    public static DeploymentFetcher fetcher(String pathServiceSid, String pathEnvironmentSid, String pathSid) {
        return new DeploymentFetcher(pathServiceSid, pathEnvironmentSid, pathSid);
    }

    public static DeploymentCreator creator(String pathServiceSid, String pathEnvironmentSid) {
        return new DeploymentCreator(pathServiceSid, pathEnvironmentSid);
    }

    public static Deployment fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Deployment)objectMapper.readValue(json, Deployment.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Deployment fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Deployment)objectMapper.readValue(json, Deployment.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Deployment(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="environment_sid") String environmentSid, @JsonProperty(value="build_sid") String buildSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.environmentSid = environmentSid;
        this.buildSid = buildSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getEnvironmentSid() {
        return this.environmentSid;
    }

    public final String getBuildSid() {
        return this.buildSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Deployment other = (Deployment)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.environmentSid, other.environmentSid) && Objects.equals(this.buildSid, other.buildSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.serviceSid, this.environmentSid, this.buildSid, this.dateCreated, this.dateUpdated, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("serviceSid", (Object)this.serviceSid).add("environmentSid", (Object)this.environmentSid).add("buildSid", (Object)this.buildSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("url", (Object)this.url).toString();
    }
}

