/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.understand.assistant;

import com.twilio.base.Updater;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.understand.assistant.AssistantFallbackActions;
import java.util.Map;

public class AssistantFallbackActionsUpdater
extends Updater<AssistantFallbackActions> {
    private final String pathAssistantSid;
    private Map<String, Object> fallbackActions;

    public AssistantFallbackActionsUpdater(String pathAssistantSid) {
        this.pathAssistantSid = pathAssistantSid;
    }

    public AssistantFallbackActionsUpdater setFallbackActions(Map<String, Object> fallbackActions) {
        this.fallbackActions = fallbackActions;
        return this;
    }

    @Override
    public AssistantFallbackActions update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), "/understand/Assistants/" + this.pathAssistantSid + "/FallbackActions");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AssistantFallbackActions update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return AssistantFallbackActions.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.fallbackActions != null) {
            request.addPostParam("FallbackActions", Converter.mapToJson(this.fallbackActions));
        }
    }
}

