/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2.regulatorycompliance.bundle;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.numbers.v2.regulatorycompliance.bundle.ItemAssignmentCreator;
import com.twilio.rest.numbers.v2.regulatorycompliance.bundle.ItemAssignmentDeleter;
import com.twilio.rest.numbers.v2.regulatorycompliance.bundle.ItemAssignmentFetcher;
import com.twilio.rest.numbers.v2.regulatorycompliance.bundle.ItemAssignmentReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ItemAssignment
extends Resource {
    private static final long serialVersionUID = 155777674150989L;
    private final String sid;
    private final String bundleSid;
    private final String accountSid;
    private final String objectSid;
    private final DateTime dateCreated;
    private final URI url;

    public static ItemAssignmentCreator creator(String pathBundleSid, String objectSid) {
        return new ItemAssignmentCreator(pathBundleSid, objectSid);
    }

    public static ItemAssignmentReader reader(String pathBundleSid) {
        return new ItemAssignmentReader(pathBundleSid);
    }

    public static ItemAssignmentFetcher fetcher(String pathBundleSid, String pathSid) {
        return new ItemAssignmentFetcher(pathBundleSid, pathSid);
    }

    public static ItemAssignmentDeleter deleter(String pathBundleSid, String pathSid) {
        return new ItemAssignmentDeleter(pathBundleSid, pathSid);
    }

    public static ItemAssignment fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (ItemAssignment)objectMapper.readValue(json, ItemAssignment.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ItemAssignment fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (ItemAssignment)objectMapper.readValue(json, ItemAssignment.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ItemAssignment(@JsonProperty(value="sid") String sid, @JsonProperty(value="bundle_sid") String bundleSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="object_sid") String objectSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.bundleSid = bundleSid;
        this.accountSid = accountSid;
        this.objectSid = objectSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getBundleSid() {
        return this.bundleSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getObjectSid() {
        return this.objectSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemAssignment other = (ItemAssignment)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.bundleSid, other.bundleSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.objectSid, other.objectSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.bundleSid, this.accountSid, this.objectSid, this.dateCreated, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("bundleSid", (Object)this.bundleSid).add("accountSid", (Object)this.accountSid).add("objectSid", (Object)this.objectSid).add("dateCreated", (Object)this.dateCreated).add("url", (Object)this.url).toString();
    }
}

