/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.events.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.events.v1.SinkCreator;
import com.twilio.rest.events.v1.SinkDeleter;
import com.twilio.rest.events.v1.SinkFetcher;
import com.twilio.rest.events.v1.SinkReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Sink
extends Resource {
    private static final long serialVersionUID = 113592032469931L;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String description;
    private final String sid;
    private final Map<String, Object> sinkConfiguration;
    private final SinkType sinkType;
    private final Status status;
    private final URI url;
    private final Map<String, String> links;

    public static SinkFetcher fetcher(String pathSid) {
        return new SinkFetcher(pathSid);
    }

    public static SinkCreator creator(String description, Map<String, Object> sinkConfiguration, SinkType sinkType) {
        return new SinkCreator(description, sinkConfiguration, sinkType);
    }

    public static SinkDeleter deleter(String pathSid) {
        return new SinkDeleter(pathSid);
    }

    public static SinkReader reader() {
        return new SinkReader();
    }

    public static Sink fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Sink)objectMapper.readValue(json, Sink.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Sink fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Sink)objectMapper.readValue(json, Sink.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Sink(@JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="description") String description, @JsonProperty(value="sid") String sid, @JsonProperty(value="sink_configuration") Map<String, Object> sinkConfiguration, @JsonProperty(value="sink_type") SinkType sinkType, @JsonProperty(value="status") Status status, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.description = description;
        this.sid = sid;
        this.sinkConfiguration = sinkConfiguration;
        this.sinkType = sinkType;
        this.status = status;
        this.url = url;
        this.links = links;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getSid() {
        return this.sid;
    }

    public final Map<String, Object> getSinkConfiguration() {
        return this.sinkConfiguration;
    }

    public final SinkType getSinkType() {
        return this.sinkType;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sink other = (Sink)o;
        return Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.description, other.description) && Objects.equals(this.sid, other.sid) && Objects.equals(this.sinkConfiguration, other.sinkConfiguration) && Objects.equals((Object)this.sinkType, (Object)other.sinkType) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dateCreated, this.dateUpdated, this.description, this.sid, this.sinkConfiguration, this.sinkType, this.status, this.url, this.links});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("description", (Object)this.description).add("sid", (Object)this.sid).add("sinkConfiguration", this.sinkConfiguration).add("sinkType", (Object)this.sinkType).add("status", (Object)this.status).add("url", (Object)this.url).add("links", this.links).toString();
    }

    public static enum SinkType {
        KINESIS("kinesis");

        private final String value;

        private SinkType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static SinkType forValue(String value) {
            return (SinkType)Promoter.enumFromString((String)value, (Enum[])SinkType.values());
        }
    }

    public static enum Status {
        INITIALIZED("initialized"),
        VALIDATING("validating"),
        ACTIVE("active"),
        FAILED("failed");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

