/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.conversations.v1.service.UserCreator;
import com.twilio.rest.conversations.v1.service.UserDeleter;
import com.twilio.rest.conversations.v1.service.UserFetcher;
import com.twilio.rest.conversations.v1.service.UserReader;
import com.twilio.rest.conversations.v1.service.UserUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class User
extends Resource {
    private static final long serialVersionUID = 251738011021352L;
    private final String sid;
    private final String accountSid;
    private final String chatServiceSid;
    private final String roleSid;
    private final String identity;
    private final String friendlyName;
    private final String attributes;
    private final Boolean isOnline;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;

    public static UserCreator creator(String pathChatServiceSid, String identity) {
        return new UserCreator(pathChatServiceSid, identity);
    }

    public static UserUpdater updater(String pathChatServiceSid, String pathSid) {
        return new UserUpdater(pathChatServiceSid, pathSid);
    }

    public static UserDeleter deleter(String pathChatServiceSid, String pathSid) {
        return new UserDeleter(pathChatServiceSid, pathSid);
    }

    public static UserFetcher fetcher(String pathChatServiceSid, String pathSid) {
        return new UserFetcher(pathChatServiceSid, pathSid);
    }

    public static UserReader reader(String pathChatServiceSid) {
        return new UserReader(pathChatServiceSid);
    }

    public static User fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (User)objectMapper.readValue(json, User.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static User fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (User)objectMapper.readValue(json, User.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private User(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="chat_service_sid") String chatServiceSid, @JsonProperty(value="role_sid") String roleSid, @JsonProperty(value="identity") String identity, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="attributes") String attributes, @JsonProperty(value="is_online") Boolean isOnline, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.chatServiceSid = chatServiceSid;
        this.roleSid = roleSid;
        this.identity = identity;
        this.friendlyName = friendlyName;
        this.attributes = attributes;
        this.isOnline = isOnline;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getChatServiceSid() {
        return this.chatServiceSid;
    }

    public final String getRoleSid() {
        return this.roleSid;
    }

    public final String getIdentity() {
        return this.identity;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getAttributes() {
        return this.attributes;
    }

    public final Boolean getIsOnline() {
        return this.isOnline;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User other = (User)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.chatServiceSid, other.chatServiceSid) && Objects.equals(this.roleSid, other.roleSid) && Objects.equals(this.identity, other.identity) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.isOnline, other.isOnline) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.chatServiceSid, this.roleSid, this.identity, this.friendlyName, this.attributes, this.isOnline, this.dateCreated, this.dateUpdated, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("chatServiceSid", (Object)this.chatServiceSid).add("roleSid", (Object)this.roleSid).add("identity", (Object)this.identity).add("friendlyName", (Object)this.friendlyName).add("attributes", (Object)this.attributes).add("isOnline", (Object)this.isOnline).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("url", (Object)this.url).toString();
    }
}

