/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.conversation.message;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.conversation.message.DeliveryReceipt;

public class DeliveryReceiptReader
extends Reader<DeliveryReceipt> {
    private final String pathConversationSid;
    private final String pathMessageSid;

    public DeliveryReceiptReader(String pathConversationSid, String pathMessageSid) {
        this.pathConversationSid = pathConversationSid;
        this.pathMessageSid = pathMessageSid;
    }

    @Override
    public ResourceSet<DeliveryReceipt> read(TwilioRestClient client) {
        return new ResourceSet<DeliveryReceipt>(this, client, this.firstPage(client));
    }

    @Override
    public Page<DeliveryReceipt> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.CONVERSATIONS.toString(), "/v1/Conversations/" + this.pathConversationSid + "/Messages/" + this.pathMessageSid + "/Receipts");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<DeliveryReceipt> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<DeliveryReceipt> nextPage(Page<DeliveryReceipt> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.CONVERSATIONS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<DeliveryReceipt> previousPage(Page<DeliveryReceipt> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.CONVERSATIONS.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<DeliveryReceipt> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("DeliveryReceipt read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("delivery_receipts", response.getContent(), DeliveryReceipt.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

