/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.conversation;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.conversation.Participant;
import org.joda.time.DateTime;

public class ParticipantUpdater
extends Updater<Participant> {
    private final String pathConversationSid;
    private final String pathSid;
    private DateTime dateCreated;
    private DateTime dateUpdated;
    private String attributes;
    private String roleSid;
    private String messagingBindingProxyAddress;
    private String messagingBindingProjectedAddress;
    private String identity;
    private Participant.WebhookEnabledType xTwilioWebhookEnabled;

    public ParticipantUpdater(String pathConversationSid, String pathSid) {
        this.pathConversationSid = pathConversationSid;
        this.pathSid = pathSid;
    }

    public ParticipantUpdater setDateCreated(DateTime dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    public ParticipantUpdater setDateUpdated(DateTime dateUpdated) {
        this.dateUpdated = dateUpdated;
        return this;
    }

    public ParticipantUpdater setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    public ParticipantUpdater setRoleSid(String roleSid) {
        this.roleSid = roleSid;
        return this;
    }

    public ParticipantUpdater setMessagingBindingProxyAddress(String messagingBindingProxyAddress) {
        this.messagingBindingProxyAddress = messagingBindingProxyAddress;
        return this;
    }

    public ParticipantUpdater setMessagingBindingProjectedAddress(String messagingBindingProjectedAddress) {
        this.messagingBindingProjectedAddress = messagingBindingProjectedAddress;
        return this;
    }

    public ParticipantUpdater setIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    public ParticipantUpdater setXTwilioWebhookEnabled(Participant.WebhookEnabledType xTwilioWebhookEnabled) {
        this.xTwilioWebhookEnabled = xTwilioWebhookEnabled;
        return this;
    }

    @Override
    public Participant update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.CONVERSATIONS.toString(), "/v1/Conversations/" + this.pathConversationSid + "/Participants/" + this.pathSid + "");
        this.addPostParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Participant update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Participant.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addHeaderParams(Request request) {
        if (this.xTwilioWebhookEnabled != null) {
            request.addHeaderParam("X-Twilio-Webhook-Enabled", this.xTwilioWebhookEnabled.toString());
        }
    }

    private void addPostParams(Request request) {
        if (this.dateCreated != null) {
            request.addPostParam("DateCreated", this.dateCreated.toString());
        }
        if (this.dateUpdated != null) {
            request.addPostParam("DateUpdated", this.dateUpdated.toString());
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
        if (this.roleSid != null) {
            request.addPostParam("RoleSid", this.roleSid);
        }
        if (this.messagingBindingProxyAddress != null) {
            request.addPostParam("MessagingBinding.ProxyAddress", this.messagingBindingProxyAddress);
        }
        if (this.messagingBindingProjectedAddress != null) {
            request.addPostParam("MessagingBinding.ProjectedAddress", this.messagingBindingProjectedAddress);
        }
        if (this.identity != null) {
            request.addPostParam("Identity", this.identity);
        }
    }
}

