/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.bulkexports.v1.export;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.bulkexports.v1.export.ExportCustomJobCreator;
import com.twilio.rest.bulkexports.v1.export.ExportCustomJobReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ExportCustomJob
extends Resource {
    private static final long serialVersionUID = 147268074422838L;
    private final String friendlyName;
    private final String resourceType;
    private final String startDay;
    private final String endDay;
    private final String webhookUrl;
    private final String webhookMethod;
    private final String email;
    private final String jobSid;
    private final Map<String, Object> details;

    public static ExportCustomJobReader reader(String pathResourceType) {
        return new ExportCustomJobReader(pathResourceType);
    }

    public static ExportCustomJobCreator creator(String pathResourceType) {
        return new ExportCustomJobCreator(pathResourceType);
    }

    public static ExportCustomJob fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (ExportCustomJob)objectMapper.readValue(json, ExportCustomJob.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ExportCustomJob fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (ExportCustomJob)objectMapper.readValue(json, ExportCustomJob.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ExportCustomJob(@JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="resource_type") String resourceType, @JsonProperty(value="start_day") String startDay, @JsonProperty(value="end_day") String endDay, @JsonProperty(value="webhook_url") String webhookUrl, @JsonProperty(value="webhook_method") String webhookMethod, @JsonProperty(value="email") String email, @JsonProperty(value="job_sid") String jobSid, @JsonProperty(value="details") Map<String, Object> details) {
        this.friendlyName = friendlyName;
        this.resourceType = resourceType;
        this.startDay = startDay;
        this.endDay = endDay;
        this.webhookUrl = webhookUrl;
        this.webhookMethod = webhookMethod;
        this.email = email;
        this.jobSid = jobSid;
        this.details = details;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getResourceType() {
        return this.resourceType;
    }

    public final String getStartDay() {
        return this.startDay;
    }

    public final String getEndDay() {
        return this.endDay;
    }

    public final String getWebhookUrl() {
        return this.webhookUrl;
    }

    public final String getWebhookMethod() {
        return this.webhookMethod;
    }

    public final String getEmail() {
        return this.email;
    }

    public final String getJobSid() {
        return this.jobSid;
    }

    public final Map<String, Object> getDetails() {
        return this.details;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExportCustomJob other = (ExportCustomJob)o;
        return Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.resourceType, other.resourceType) && Objects.equals(this.startDay, other.startDay) && Objects.equals(this.endDay, other.endDay) && Objects.equals(this.webhookUrl, other.webhookUrl) && Objects.equals(this.webhookMethod, other.webhookMethod) && Objects.equals(this.email, other.email) && Objects.equals(this.jobSid, other.jobSid) && Objects.equals(this.details, other.details);
    }

    public int hashCode() {
        return Objects.hash(this.friendlyName, this.resourceType, this.startDay, this.endDay, this.webhookUrl, this.webhookMethod, this.email, this.jobSid, this.details);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("friendlyName", (Object)this.friendlyName).add("resourceType", (Object)this.resourceType).add("startDay", (Object)this.startDay).add("endDay", (Object)this.endDay).add("webhookUrl", (Object)this.webhookUrl).add("webhookMethod", (Object)this.webhookMethod).add("email", (Object)this.email).add("jobSid", (Object)this.jobSid).add("details", this.details).toString();
    }
}

