/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.autopilot.v1.assistant;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.autopilot.v1.assistant.FieldType;

public class FieldTypeCreator
extends Creator<FieldType> {
    private final String pathAssistantSid;
    private final String uniqueName;
    private String friendlyName;

    public FieldTypeCreator(String pathAssistantSid, String uniqueName) {
        this.pathAssistantSid = pathAssistantSid;
        this.uniqueName = uniqueName;
    }

    public FieldTypeCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    @Override
    public FieldType create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.AUTOPILOT.toString(), "/v1/Assistants/" + this.pathAssistantSid + "/FieldTypes");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("FieldType creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return FieldType.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
    }
}

