/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.Address;

public class AddressReader
extends Reader<Address> {
    private String pathAccountSid;
    private String customerName;
    private String friendlyName;
    private String isoCountry;

    public AddressReader() {
    }

    public AddressReader(String pathAccountSid) {
        this.pathAccountSid = pathAccountSid;
    }

    public AddressReader setCustomerName(String customerName) {
        this.customerName = customerName;
        return this;
    }

    public AddressReader setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public AddressReader setIsoCountry(String isoCountry) {
        this.isoCountry = isoCountry;
        return this;
    }

    @Override
    public ResourceSet<Address> read(TwilioRestClient client) {
        return new ResourceSet<Address>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Address> firstPage(TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathAccountSid + "/Addresses.json");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Address> getPage(String targetUrl, TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Address> nextPage(Page<Address> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Address> previousPage(Page<Address> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<Address> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Address read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("addresses", response.getContent(), Address.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.customerName != null) {
            request.addQueryParam("CustomerName", this.customerName);
        }
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        if (this.isoCountry != null) {
            request.addQueryParam("IsoCountry", this.isoCountry);
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

