/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml;

import com.google.common.base.MoreObjects;
import com.twilio.twiml.GenericNode;
import com.twilio.twiml.Text;
import com.twilio.twiml.TwiMLException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class TwiML {
    private final String tagName;
    private final Builder builder;
    private static final Map<String, String> attrNameMapper = Collections.singletonMap("for_", "for");

    protected TwiML(String tagName, Builder builder) {
        this.tagName = tagName;
        this.builder = builder;
    }

    protected String getElementBody() {
        return null;
    }

    protected Map<String, String> getElementAttributes() {
        return new HashMap<String, String>();
    }

    public String getTagName() {
        return this.tagName;
    }

    public List<TwiML> getChildren() {
        return this.builder.children;
    }

    public Map<String, String> getOptions() {
        return this.builder.options;
    }

    private String getTransformedAttrName(String attrName) {
        return attrNameMapper.containsKey(attrName) ? attrNameMapper.get(attrName) : attrName;
    }

    protected Node buildXmlElement(Document parentDoc) {
        Element node = parentDoc.createElement(this.getTagName());
        String body = this.getElementBody();
        if (body != null) {
            node.appendChild(parentDoc.createTextNode(body));
        }
        for (Map.Entry<String, String> entry : this.getElementAttributes().entrySet()) {
            node.setAttribute(this.getTransformedAttrName(entry.getKey()), entry.getValue());
        }
        for (TwiML twiML : this.getChildren()) {
            node.appendChild(twiML.buildXmlElement(parentDoc));
        }
        for (Map.Entry entry : this.getOptions().entrySet()) {
            node.setAttribute((String)entry.getKey(), (String)entry.getValue());
        }
        return node;
    }

    public String toXml() throws TwiMLException {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            doc.setXmlStandalone(true);
            doc.appendChild(this.buildXmlElement(doc));
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "no");
            DOMSource source = new DOMSource(doc);
            StreamResult output = new StreamResult(new StringWriter());
            transformer.transform(source, output);
            return output.getWriter().toString().trim();
        }
        catch (TransformerException te) {
            throw new TwiMLException("Exception serializing TwiML: " + te.getMessage());
        }
        catch (Exception e) {
            throw new TwiMLException("Unhandled exception: " + e.getMessage());
        }
    }

    public String toUrl() throws TwiMLException {
        try {
            return URLEncoder.encode(this.toXml(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new TwiMLException(e.getMessage());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TwiML twiml = (TwiML)o;
        return Objects.equals(this.getTagName(), twiml.getTagName()) && Objects.equals(this.getElementBody(), twiml.getElementBody()) && Objects.equals(this.getElementAttributes(), twiml.getElementAttributes()) && Objects.equals(this.getOptions(), twiml.getOptions()) && Objects.equals(this.getChildren(), twiml.getChildren());
    }

    public int hashCode() {
        return Objects.hash(this.getTagName(), this.getElementBody(), this.getElementAttributes(), this.getChildren(), this.getOptions());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Body", (Object)this.getElementBody()).add("Attributes", this.getElementAttributes()).add("Children", this.getChildren()).add("Options", this.getOptions()).toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected Map<String, String> options = new HashMap<String, String>();
        protected List<TwiML> children = new ArrayList<TwiML>();

        public T option(String key, String value) {
            this.options.put(key, value);
            return (T)this;
        }

        public T addText(String text) {
            this.children.add(new Text(text));
            return (T)this;
        }

        public T addChild(GenericNode node) {
            this.children.add(node);
            return (T)this;
        }
    }
}

