/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.voice.v1.dialingpermissions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.voice.v1.dialingpermissions.SettingsFetcher;
import com.twilio.rest.voice.v1.dialingpermissions.SettingsUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Settings
extends Resource {
    private static final long serialVersionUID = 187417080450761L;
    private final Boolean dialingPermissionsInheritance;
    private final URI url;

    public static SettingsFetcher fetcher() {
        return new SettingsFetcher();
    }

    public static SettingsUpdater updater() {
        return new SettingsUpdater();
    }

    public static Settings fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Settings)objectMapper.readValue(json, Settings.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Settings fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Settings)objectMapper.readValue(json, Settings.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Settings(@JsonProperty(value="dialing_permissions_inheritance") Boolean dialingPermissionsInheritance, @JsonProperty(value="url") URI url) {
        this.dialingPermissionsInheritance = dialingPermissionsInheritance;
        this.url = url;
    }

    public final Boolean getDialingPermissionsInheritance() {
        return this.dialingPermissionsInheritance;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Settings other = (Settings)o;
        return Objects.equals(this.dialingPermissionsInheritance, other.dialingPermissionsInheritance) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.dialingPermissionsInheritance, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dialingPermissionsInheritance", (Object)this.dialingPermissionsInheritance).add("url", (Object)this.url).toString();
    }
}

