/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.voice.v1;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.voice.v1.SourceIpMapping;

public class SourceIpMappingCreator
extends Creator<SourceIpMapping> {
    private final String ipRecordSid;
    private final String sipDomainSid;

    public SourceIpMappingCreator(String ipRecordSid, String sipDomainSid) {
        this.ipRecordSid = ipRecordSid;
        this.sipDomainSid = sipDomainSid;
    }

    @Override
    public SourceIpMapping create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.VOICE.toString(), "/v1/SourceIpMappings");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SourceIpMapping creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return SourceIpMapping.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.ipRecordSid != null) {
            request.addPostParam("IpRecordSid", this.ipRecordSid);
        }
        if (this.sipDomainSid != null) {
            request.addPostParam("SipDomainSid", this.sipDomainSid);
        }
    }
}

