/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.voice.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.voice.v1.IpRecordCreator;
import com.twilio.rest.voice.v1.IpRecordDeleter;
import com.twilio.rest.voice.v1.IpRecordFetcher;
import com.twilio.rest.voice.v1.IpRecordReader;
import com.twilio.rest.voice.v1.IpRecordUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IpRecord
extends Resource {
    private static final long serialVersionUID = 74904859917733L;
    private final String accountSid;
    private final String sid;
    private final String friendlyName;
    private final String ipAddress;
    private final Integer cidrPrefixLength;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;

    public static IpRecordCreator creator(String ipAddress) {
        return new IpRecordCreator(ipAddress);
    }

    public static IpRecordFetcher fetcher(String pathSid) {
        return new IpRecordFetcher(pathSid);
    }

    public static IpRecordReader reader() {
        return new IpRecordReader();
    }

    public static IpRecordUpdater updater(String pathSid) {
        return new IpRecordUpdater(pathSid);
    }

    public static IpRecordDeleter deleter(String pathSid) {
        return new IpRecordDeleter(pathSid);
    }

    public static IpRecord fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (IpRecord)objectMapper.readValue(json, IpRecord.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static IpRecord fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (IpRecord)objectMapper.readValue(json, IpRecord.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private IpRecord(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="ip_address") String ipAddress, @JsonProperty(value="cidr_prefix_length") Integer cidrPrefixLength, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.sid = sid;
        this.friendlyName = friendlyName;
        this.ipAddress = ipAddress;
        this.cidrPrefixLength = cidrPrefixLength;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getIpAddress() {
        return this.ipAddress;
    }

    public final Integer getCidrPrefixLength() {
        return this.cidrPrefixLength;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IpRecord other = (IpRecord)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.ipAddress, other.ipAddress) && Objects.equals(this.cidrPrefixLength, other.cidrPrefixLength) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.sid, this.friendlyName, this.ipAddress, this.cidrPrefixLength, this.dateCreated, this.dateUpdated, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("sid", (Object)this.sid).add("friendlyName", (Object)this.friendlyName).add("ipAddress", (Object)this.ipAddress).add("cidrPrefixLength", (Object)this.cidrPrefixLength).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("url", (Object)this.url).toString();
    }
}

