/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.voice.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.voice.v1.ConnectionPolicyCreator;
import com.twilio.rest.voice.v1.ConnectionPolicyDeleter;
import com.twilio.rest.voice.v1.ConnectionPolicyFetcher;
import com.twilio.rest.voice.v1.ConnectionPolicyReader;
import com.twilio.rest.voice.v1.ConnectionPolicyUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ConnectionPolicy
extends Resource {
    private static final long serialVersionUID = 84226976776172L;
    private final String accountSid;
    private final String sid;
    private final String friendlyName;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;
    private final Map<String, String> links;

    public static ConnectionPolicyCreator creator() {
        return new ConnectionPolicyCreator();
    }

    public static ConnectionPolicyFetcher fetcher(String pathSid) {
        return new ConnectionPolicyFetcher(pathSid);
    }

    public static ConnectionPolicyReader reader() {
        return new ConnectionPolicyReader();
    }

    public static ConnectionPolicyUpdater updater(String pathSid) {
        return new ConnectionPolicyUpdater(pathSid);
    }

    public static ConnectionPolicyDeleter deleter(String pathSid) {
        return new ConnectionPolicyDeleter(pathSid);
    }

    public static ConnectionPolicy fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (ConnectionPolicy)objectMapper.readValue(json, ConnectionPolicy.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ConnectionPolicy fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (ConnectionPolicy)objectMapper.readValue(json, ConnectionPolicy.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ConnectionPolicy(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.accountSid = accountSid;
        this.sid = sid;
        this.friendlyName = friendlyName;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.links = links;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionPolicy other = (ConnectionPolicy)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.sid, this.friendlyName, this.dateCreated, this.dateUpdated, this.url, this.links);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("sid", (Object)this.sid).add("friendlyName", (Object)this.friendlyName).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("url", (Object)this.url).add("links", this.links).toString();
    }
}

