/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.video.v1.RecordingSettingsCreator;
import com.twilio.rest.video.v1.RecordingSettingsFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RecordingSettings
extends Resource {
    private static final long serialVersionUID = 41622584466212L;
    private final String accountSid;
    private final String friendlyName;
    private final String awsCredentialsSid;
    private final URI awsS3Url;
    private final Boolean awsStorageEnabled;
    private final String encryptionKeySid;
    private final Boolean encryptionEnabled;
    private final URI url;

    public static RecordingSettingsFetcher fetcher() {
        return new RecordingSettingsFetcher();
    }

    public static RecordingSettingsCreator creator(String friendlyName) {
        return new RecordingSettingsCreator(friendlyName);
    }

    public static RecordingSettings fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (RecordingSettings)objectMapper.readValue(json, RecordingSettings.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static RecordingSettings fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (RecordingSettings)objectMapper.readValue(json, RecordingSettings.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private RecordingSettings(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="aws_credentials_sid") String awsCredentialsSid, @JsonProperty(value="aws_s3_url") URI awsS3Url, @JsonProperty(value="aws_storage_enabled") Boolean awsStorageEnabled, @JsonProperty(value="encryption_key_sid") String encryptionKeySid, @JsonProperty(value="encryption_enabled") Boolean encryptionEnabled, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.awsCredentialsSid = awsCredentialsSid;
        this.awsS3Url = awsS3Url;
        this.awsStorageEnabled = awsStorageEnabled;
        this.encryptionKeySid = encryptionKeySid;
        this.encryptionEnabled = encryptionEnabled;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getAwsCredentialsSid() {
        return this.awsCredentialsSid;
    }

    public final URI getAwsS3Url() {
        return this.awsS3Url;
    }

    public final Boolean getAwsStorageEnabled() {
        return this.awsStorageEnabled;
    }

    public final String getEncryptionKeySid() {
        return this.encryptionKeySid;
    }

    public final Boolean getEncryptionEnabled() {
        return this.encryptionEnabled;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordingSettings other = (RecordingSettings)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.awsCredentialsSid, other.awsCredentialsSid) && Objects.equals(this.awsS3Url, other.awsS3Url) && Objects.equals(this.awsStorageEnabled, other.awsStorageEnabled) && Objects.equals(this.encryptionKeySid, other.encryptionKeySid) && Objects.equals(this.encryptionEnabled, other.encryptionEnabled) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.friendlyName, this.awsCredentialsSid, this.awsS3Url, this.awsStorageEnabled, this.encryptionKeySid, this.encryptionEnabled, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("friendlyName", (Object)this.friendlyName).add("awsCredentialsSid", (Object)this.awsCredentialsSid).add("awsS3Url", (Object)this.awsS3Url).add("awsStorageEnabled", (Object)this.awsStorageEnabled).add("encryptionKeySid", (Object)this.encryptionKeySid).add("encryptionEnabled", (Object)this.encryptionEnabled).add("url", (Object)this.url).toString();
    }
}

