/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.video.v1.CompositionSettings;
import java.net.URI;

public class CompositionSettingsCreator
extends Creator<CompositionSettings> {
    private final String friendlyName;
    private String awsCredentialsSid;
    private String encryptionKeySid;
    private URI awsS3Url;
    private Boolean awsStorageEnabled;
    private Boolean encryptionEnabled;

    public CompositionSettingsCreator(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public CompositionSettingsCreator setAwsCredentialsSid(String awsCredentialsSid) {
        this.awsCredentialsSid = awsCredentialsSid;
        return this;
    }

    public CompositionSettingsCreator setEncryptionKeySid(String encryptionKeySid) {
        this.encryptionKeySid = encryptionKeySid;
        return this;
    }

    public CompositionSettingsCreator setAwsS3Url(URI awsS3Url) {
        this.awsS3Url = awsS3Url;
        return this;
    }

    public CompositionSettingsCreator setAwsS3Url(String awsS3Url) {
        return this.setAwsS3Url(Promoter.uriFromString(awsS3Url));
    }

    public CompositionSettingsCreator setAwsStorageEnabled(Boolean awsStorageEnabled) {
        this.awsStorageEnabled = awsStorageEnabled;
        return this;
    }

    public CompositionSettingsCreator setEncryptionEnabled(Boolean encryptionEnabled) {
        this.encryptionEnabled = encryptionEnabled;
        return this;
    }

    @Override
    public CompositionSettings create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.VIDEO.toString(), "/v1/CompositionSettings/Default");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CompositionSettings creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return CompositionSettings.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.awsCredentialsSid != null) {
            request.addPostParam("AwsCredentialsSid", this.awsCredentialsSid);
        }
        if (this.encryptionKeySid != null) {
            request.addPostParam("EncryptionKeySid", this.encryptionKeySid);
        }
        if (this.awsS3Url != null) {
            request.addPostParam("AwsS3Url", this.awsS3Url.toString());
        }
        if (this.awsStorageEnabled != null) {
            request.addPostParam("AwsStorageEnabled", this.awsStorageEnabled.toString());
        }
        if (this.encryptionEnabled != null) {
            request.addPostParam("EncryptionEnabled", this.encryptionEnabled.toString());
        }
    }
}

