/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service.ratelimit;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.verify.v2.service.ratelimit.BucketCreator;
import com.twilio.rest.verify.v2.service.ratelimit.BucketDeleter;
import com.twilio.rest.verify.v2.service.ratelimit.BucketFetcher;
import com.twilio.rest.verify.v2.service.ratelimit.BucketReader;
import com.twilio.rest.verify.v2.service.ratelimit.BucketUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Bucket
extends Resource {
    private static final long serialVersionUID = 11459173991897L;
    private final String sid;
    private final String rateLimitSid;
    private final String serviceSid;
    private final String accountSid;
    private final Integer max;
    private final Integer interval;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;

    public static BucketCreator creator(String pathServiceSid, String pathRateLimitSid, Integer max, Integer interval) {
        return new BucketCreator(pathServiceSid, pathRateLimitSid, max, interval);
    }

    public static BucketUpdater updater(String pathServiceSid, String pathRateLimitSid, String pathSid) {
        return new BucketUpdater(pathServiceSid, pathRateLimitSid, pathSid);
    }

    public static BucketFetcher fetcher(String pathServiceSid, String pathRateLimitSid, String pathSid) {
        return new BucketFetcher(pathServiceSid, pathRateLimitSid, pathSid);
    }

    public static BucketReader reader(String pathServiceSid, String pathRateLimitSid) {
        return new BucketReader(pathServiceSid, pathRateLimitSid);
    }

    public static BucketDeleter deleter(String pathServiceSid, String pathRateLimitSid, String pathSid) {
        return new BucketDeleter(pathServiceSid, pathRateLimitSid, pathSid);
    }

    public static Bucket fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Bucket)objectMapper.readValue(json, Bucket.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Bucket fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Bucket)objectMapper.readValue(json, Bucket.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Bucket(@JsonProperty(value="sid") String sid, @JsonProperty(value="rate_limit_sid") String rateLimitSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="max") Integer max, @JsonProperty(value="interval") Integer interval, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.rateLimitSid = rateLimitSid;
        this.serviceSid = serviceSid;
        this.accountSid = accountSid;
        this.max = max;
        this.interval = interval;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getRateLimitSid() {
        return this.rateLimitSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Integer getMax() {
        return this.max;
    }

    public final Integer getInterval() {
        return this.interval;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bucket other = (Bucket)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.rateLimitSid, other.rateLimitSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.max, other.max) && Objects.equals(this.interval, other.interval) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.rateLimitSid, this.serviceSid, this.accountSid, this.max, this.interval, this.dateCreated, this.dateUpdated, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("rateLimitSid", (Object)this.rateLimitSid).add("serviceSid", (Object)this.serviceSid).add("accountSid", (Object)this.accountSid).add("max", (Object)this.max).add("interval", (Object)this.interval).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("url", (Object)this.url).toString();
    }
}

