/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service.entity;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.service.entity.Factor;

public class FactorUpdater
extends Updater<Factor> {
    private final String pathServiceSid;
    private final String pathIdentity;
    private final String pathSid;
    private String authPayload;
    private String friendlyName;
    private String config;
    private String twilioSandboxMode;

    public FactorUpdater(String pathServiceSid, String pathIdentity, String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathIdentity = pathIdentity;
        this.pathSid = pathSid;
    }

    public FactorUpdater setAuthPayload(String authPayload) {
        this.authPayload = authPayload;
        return this;
    }

    public FactorUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public FactorUpdater setConfig(String config) {
        this.config = config;
        return this;
    }

    public FactorUpdater setTwilioSandboxMode(String twilioSandboxMode) {
        this.twilioSandboxMode = twilioSandboxMode;
        return this;
    }

    @Override
    public Factor update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.VERIFY.toString(), "/v2/Services/" + this.pathServiceSid + "/Entities/" + this.pathIdentity + "/Factors/" + this.pathSid + "");
        this.addPostParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Factor update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Factor.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addHeaderParams(Request request) {
        if (this.twilioSandboxMode != null) {
            request.addHeaderParam("Twilio-Sandbox-Mode", this.twilioSandboxMode);
        }
    }

    private void addPostParams(Request request) {
        if (this.authPayload != null) {
            request.addPostParam("AuthPayload", this.authPayload);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.config != null) {
            request.addPostParam("Config", this.config);
        }
    }
}

