/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trunking.v1.trunk;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.trunking.v1.trunk.Recording;

public class RecordingUpdater
extends Updater<Recording> {
    private final String pathTrunkSid;

    public RecordingUpdater(String pathTrunkSid) {
        this.pathTrunkSid = pathTrunkSid;
    }

    @Override
    public Recording update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.TRUNKING.toString(), "/v1/Trunks/" + this.pathTrunkSid + "/Recording");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Recording update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Recording.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
    }
}

