/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v2.flow;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.studio.v2.flow.FlowRevision;

public class FlowRevisionReader
extends Reader<FlowRevision> {
    private final String pathSid;

    public FlowRevisionReader(String pathSid) {
        this.pathSid = pathSid;
    }

    @Override
    public ResourceSet<FlowRevision> read(TwilioRestClient client) {
        return new ResourceSet<FlowRevision>(this, client, this.firstPage(client));
    }

    @Override
    public Page<FlowRevision> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.STUDIO.toString(), "/v2/Flows/" + this.pathSid + "/Revisions");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<FlowRevision> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<FlowRevision> nextPage(Page<FlowRevision> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.STUDIO.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<FlowRevision> previousPage(Page<FlowRevision> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.STUDIO.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<FlowRevision> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("FlowRevision read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("revisions", response.getContent(), FlowRevision.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

