/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v2.flow;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.studio.v2.flow.FlowRevision;

public class FlowRevisionFetcher
extends Fetcher<FlowRevision> {
    private final String pathSid;
    private final String pathRevision;

    public FlowRevisionFetcher(String pathSid, String pathRevision) {
        this.pathSid = pathSid;
        this.pathRevision = pathRevision;
    }

    @Override
    public FlowRevision fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.STUDIO.toString(), "/v2/Flows/" + this.pathSid + "/Revisions/" + this.pathRevision + "");
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("FlowRevision fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return FlowRevision.fromJson(response.getStream(), client.getObjectMapper());
    }
}

