/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.proxy.v1.service;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.proxy.v1.service.PhoneNumber;

public class PhoneNumberCreator
extends Creator<PhoneNumber> {
    private final String pathServiceSid;
    private String sid;
    private com.twilio.type.PhoneNumber phoneNumber;
    private Boolean isReserved;

    public PhoneNumberCreator(String pathServiceSid) {
        this.pathServiceSid = pathServiceSid;
    }

    public PhoneNumberCreator setSid(String sid) {
        this.sid = sid;
        return this;
    }

    public PhoneNumberCreator setPhoneNumber(com.twilio.type.PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    public PhoneNumberCreator setPhoneNumber(String phoneNumber) {
        return this.setPhoneNumber(Promoter.phoneNumberFromString(phoneNumber));
    }

    public PhoneNumberCreator setIsReserved(Boolean isReserved) {
        this.isReserved = isReserved;
        return this;
    }

    @Override
    public PhoneNumber create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PROXY.toString(), "/v1/Services/" + this.pathServiceSid + "/PhoneNumbers");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("PhoneNumber creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return PhoneNumber.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.sid != null) {
            request.addPostParam("Sid", this.sid);
        }
        if (this.phoneNumber != null) {
            request.addPostParam("PhoneNumber", this.phoneNumber.toString());
        }
        if (this.isReserved != null) {
            request.addPostParam("IsReserved", this.isReserved.toString());
        }
    }
}

