/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.proxy.v1;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.proxy.v1.Service;
import java.net.URI;

public class ServiceCreator
extends Creator<Service> {
    private final String uniqueName;
    private Integer defaultTtl;
    private URI callbackUrl;
    private Service.GeoMatchLevel geoMatchLevel;
    private Service.NumberSelectionBehavior numberSelectionBehavior;
    private URI interceptCallbackUrl;
    private URI outOfSessionCallbackUrl;
    private String chatInstanceSid;

    public ServiceCreator(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    public ServiceCreator setDefaultTtl(Integer defaultTtl) {
        this.defaultTtl = defaultTtl;
        return this;
    }

    public ServiceCreator setCallbackUrl(URI callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public ServiceCreator setCallbackUrl(String callbackUrl) {
        return this.setCallbackUrl(Promoter.uriFromString(callbackUrl));
    }

    public ServiceCreator setGeoMatchLevel(Service.GeoMatchLevel geoMatchLevel) {
        this.geoMatchLevel = geoMatchLevel;
        return this;
    }

    public ServiceCreator setNumberSelectionBehavior(Service.NumberSelectionBehavior numberSelectionBehavior) {
        this.numberSelectionBehavior = numberSelectionBehavior;
        return this;
    }

    public ServiceCreator setInterceptCallbackUrl(URI interceptCallbackUrl) {
        this.interceptCallbackUrl = interceptCallbackUrl;
        return this;
    }

    public ServiceCreator setInterceptCallbackUrl(String interceptCallbackUrl) {
        return this.setInterceptCallbackUrl(Promoter.uriFromString(interceptCallbackUrl));
    }

    public ServiceCreator setOutOfSessionCallbackUrl(URI outOfSessionCallbackUrl) {
        this.outOfSessionCallbackUrl = outOfSessionCallbackUrl;
        return this;
    }

    public ServiceCreator setOutOfSessionCallbackUrl(String outOfSessionCallbackUrl) {
        return this.setOutOfSessionCallbackUrl(Promoter.uriFromString(outOfSessionCallbackUrl));
    }

    public ServiceCreator setChatInstanceSid(String chatInstanceSid) {
        this.chatInstanceSid = chatInstanceSid;
        return this;
    }

    @Override
    public Service create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PROXY.toString(), "/v1/Services");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Service creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Service.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.defaultTtl != null) {
            request.addPostParam("DefaultTtl", this.defaultTtl.toString());
        }
        if (this.callbackUrl != null) {
            request.addPostParam("CallbackUrl", this.callbackUrl.toString());
        }
        if (this.geoMatchLevel != null) {
            request.addPostParam("GeoMatchLevel", this.geoMatchLevel.toString());
        }
        if (this.numberSelectionBehavior != null) {
            request.addPostParam("NumberSelectionBehavior", this.numberSelectionBehavior.toString());
        }
        if (this.interceptCallbackUrl != null) {
            request.addPostParam("InterceptCallbackUrl", this.interceptCallbackUrl.toString());
        }
        if (this.outOfSessionCallbackUrl != null) {
            request.addPostParam("OutOfSessionCallbackUrl", this.outOfSessionCallbackUrl.toString());
        }
        if (this.chatInstanceSid != null) {
            request.addPostParam("ChatInstanceSid", this.chatInstanceSid);
        }
    }
}

