/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.trustedComms.business.brand.brandedchannel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.trustedComms.business.brand.brandedchannel.ChannelCreator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Channel
extends Resource {
    private static final long serialVersionUID = 99311524255768L;
    private final String accountSid;
    private final String businessSid;
    private final String brandSid;
    private final String brandedChannelSid;
    private final String phoneNumberSid;
    private final String phoneNumber;
    private final URI url;

    public static ChannelCreator creator(String pathBusinessSid, String pathBrandSid, String pathBrandedChannelSid, String phoneNumberSid) {
        return new ChannelCreator(pathBusinessSid, pathBrandSid, pathBrandedChannelSid, phoneNumberSid);
    }

    public static Channel fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Channel)objectMapper.readValue(json, Channel.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Channel fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Channel)objectMapper.readValue(json, Channel.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Channel(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="business_sid") String businessSid, @JsonProperty(value="brand_sid") String brandSid, @JsonProperty(value="branded_channel_sid") String brandedChannelSid, @JsonProperty(value="phone_number_sid") String phoneNumberSid, @JsonProperty(value="phone_number") String phoneNumber, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.businessSid = businessSid;
        this.brandSid = brandSid;
        this.brandedChannelSid = brandedChannelSid;
        this.phoneNumberSid = phoneNumberSid;
        this.phoneNumber = phoneNumber;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getBusinessSid() {
        return this.businessSid;
    }

    public final String getBrandSid() {
        return this.brandSid;
    }

    public final String getBrandedChannelSid() {
        return this.brandedChannelSid;
    }

    public final String getPhoneNumberSid() {
        return this.phoneNumberSid;
    }

    public final String getPhoneNumber() {
        return this.phoneNumber;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Channel other = (Channel)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.businessSid, other.businessSid) && Objects.equals(this.brandSid, other.brandSid) && Objects.equals(this.brandedChannelSid, other.brandedChannelSid) && Objects.equals(this.phoneNumberSid, other.phoneNumberSid) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.businessSid, this.brandSid, this.brandedChannelSid, this.phoneNumberSid, this.phoneNumber, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("businessSid", (Object)this.businessSid).add("brandSid", (Object)this.brandSid).add("brandedChannelSid", (Object)this.brandedChannelSid).add("phoneNumberSid", (Object)this.phoneNumberSid).add("phoneNumber", (Object)this.phoneNumber).add("url", (Object)this.url).toString();
    }
}

