/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.trustedComms;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.trustedComms.PhoneCall;
import java.net.URI;
import java.util.List;

public class PhoneCallCreator
extends Creator<PhoneCall> {
    private final String from;
    private final String to;
    private String reason;
    private String applicationSid;
    private String callerId;
    private HttpMethod fallbackMethod;
    private URI fallbackUrl;
    private String machineDetection;
    private Integer machineDetectionSilenceTimeout;
    private Integer machineDetectionSpeechEndThreshold;
    private Integer machineDetectionSpeechThreshold;
    private Integer machineDetectionTimeout;
    private HttpMethod method;
    private Boolean record;
    private String recordingChannels;
    private String recordingStatusCallback;
    private List<String> recordingStatusCallbackEvent;
    private HttpMethod recordingStatusCallbackMethod;
    private String sendDigits;
    private String sipAuthPassword;
    private String sipAuthUsername;
    private URI statusCallback;
    private List<String> statusCallbackEvent;
    private HttpMethod statusCallbackMethod;
    private Integer timeout;
    private String trim;
    private URI url;

    public PhoneCallCreator(String from, String to) {
        this.from = from;
        this.to = to;
    }

    public PhoneCallCreator setReason(String reason) {
        this.reason = reason;
        return this;
    }

    public PhoneCallCreator setApplicationSid(String applicationSid) {
        this.applicationSid = applicationSid;
        return this;
    }

    public PhoneCallCreator setCallerId(String callerId) {
        this.callerId = callerId;
        return this;
    }

    public PhoneCallCreator setFallbackMethod(HttpMethod fallbackMethod) {
        this.fallbackMethod = fallbackMethod;
        return this;
    }

    public PhoneCallCreator setFallbackUrl(URI fallbackUrl) {
        this.fallbackUrl = fallbackUrl;
        return this;
    }

    public PhoneCallCreator setFallbackUrl(String fallbackUrl) {
        return this.setFallbackUrl(Promoter.uriFromString(fallbackUrl));
    }

    public PhoneCallCreator setMachineDetection(String machineDetection) {
        this.machineDetection = machineDetection;
        return this;
    }

    public PhoneCallCreator setMachineDetectionSilenceTimeout(Integer machineDetectionSilenceTimeout) {
        this.machineDetectionSilenceTimeout = machineDetectionSilenceTimeout;
        return this;
    }

    public PhoneCallCreator setMachineDetectionSpeechEndThreshold(Integer machineDetectionSpeechEndThreshold) {
        this.machineDetectionSpeechEndThreshold = machineDetectionSpeechEndThreshold;
        return this;
    }

    public PhoneCallCreator setMachineDetectionSpeechThreshold(Integer machineDetectionSpeechThreshold) {
        this.machineDetectionSpeechThreshold = machineDetectionSpeechThreshold;
        return this;
    }

    public PhoneCallCreator setMachineDetectionTimeout(Integer machineDetectionTimeout) {
        this.machineDetectionTimeout = machineDetectionTimeout;
        return this;
    }

    public PhoneCallCreator setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    public PhoneCallCreator setRecord(Boolean record) {
        this.record = record;
        return this;
    }

    public PhoneCallCreator setRecordingChannels(String recordingChannels) {
        this.recordingChannels = recordingChannels;
        return this;
    }

    public PhoneCallCreator setRecordingStatusCallback(String recordingStatusCallback) {
        this.recordingStatusCallback = recordingStatusCallback;
        return this;
    }

    public PhoneCallCreator setRecordingStatusCallbackEvent(List<String> recordingStatusCallbackEvent) {
        this.recordingStatusCallbackEvent = recordingStatusCallbackEvent;
        return this;
    }

    public PhoneCallCreator setRecordingStatusCallbackEvent(String recordingStatusCallbackEvent) {
        return this.setRecordingStatusCallbackEvent(Promoter.listOfOne(recordingStatusCallbackEvent));
    }

    public PhoneCallCreator setRecordingStatusCallbackMethod(HttpMethod recordingStatusCallbackMethod) {
        this.recordingStatusCallbackMethod = recordingStatusCallbackMethod;
        return this;
    }

    public PhoneCallCreator setSendDigits(String sendDigits) {
        this.sendDigits = sendDigits;
        return this;
    }

    public PhoneCallCreator setSipAuthPassword(String sipAuthPassword) {
        this.sipAuthPassword = sipAuthPassword;
        return this;
    }

    public PhoneCallCreator setSipAuthUsername(String sipAuthUsername) {
        this.sipAuthUsername = sipAuthUsername;
        return this;
    }

    public PhoneCallCreator setStatusCallback(URI statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    public PhoneCallCreator setStatusCallback(String statusCallback) {
        return this.setStatusCallback(Promoter.uriFromString(statusCallback));
    }

    public PhoneCallCreator setStatusCallbackEvent(List<String> statusCallbackEvent) {
        this.statusCallbackEvent = statusCallbackEvent;
        return this;
    }

    public PhoneCallCreator setStatusCallbackEvent(String statusCallbackEvent) {
        return this.setStatusCallbackEvent(Promoter.listOfOne(statusCallbackEvent));
    }

    public PhoneCallCreator setStatusCallbackMethod(HttpMethod statusCallbackMethod) {
        this.statusCallbackMethod = statusCallbackMethod;
        return this;
    }

    public PhoneCallCreator setTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public PhoneCallCreator setTrim(String trim) {
        this.trim = trim;
        return this;
    }

    public PhoneCallCreator setUrl(URI url) {
        this.url = url;
        return this;
    }

    public PhoneCallCreator setUrl(String url) {
        return this.setUrl(Promoter.uriFromString(url));
    }

    @Override
    public PhoneCall create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), "/TrustedComms/Business/PhoneCalls");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("PhoneCall creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return PhoneCall.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.from != null) {
            request.addPostParam("From", this.from);
        }
        if (this.to != null) {
            request.addPostParam("To", this.to);
        }
        if (this.reason != null) {
            request.addPostParam("Reason", this.reason);
        }
        if (this.applicationSid != null) {
            request.addPostParam("ApplicationSid", this.applicationSid);
        }
        if (this.callerId != null) {
            request.addPostParam("CallerId", this.callerId);
        }
        if (this.fallbackMethod != null) {
            request.addPostParam("FallbackMethod", this.fallbackMethod.toString());
        }
        if (this.fallbackUrl != null) {
            request.addPostParam("FallbackUrl", this.fallbackUrl.toString());
        }
        if (this.machineDetection != null) {
            request.addPostParam("MachineDetection", this.machineDetection);
        }
        if (this.machineDetectionSilenceTimeout != null) {
            request.addPostParam("MachineDetectionSilenceTimeout", this.machineDetectionSilenceTimeout.toString());
        }
        if (this.machineDetectionSpeechEndThreshold != null) {
            request.addPostParam("MachineDetectionSpeechEndThreshold", this.machineDetectionSpeechEndThreshold.toString());
        }
        if (this.machineDetectionSpeechThreshold != null) {
            request.addPostParam("MachineDetectionSpeechThreshold", this.machineDetectionSpeechThreshold.toString());
        }
        if (this.machineDetectionTimeout != null) {
            request.addPostParam("MachineDetectionTimeout", this.machineDetectionTimeout.toString());
        }
        if (this.method != null) {
            request.addPostParam("Method", this.method.toString());
        }
        if (this.record != null) {
            request.addPostParam("Record", this.record.toString());
        }
        if (this.recordingChannels != null) {
            request.addPostParam("RecordingChannels", this.recordingChannels);
        }
        if (this.recordingStatusCallback != null) {
            request.addPostParam("RecordingStatusCallback", this.recordingStatusCallback);
        }
        if (this.recordingStatusCallbackEvent != null) {
            for (String prop : this.recordingStatusCallbackEvent) {
                request.addPostParam("RecordingStatusCallbackEvent", prop);
            }
        }
        if (this.recordingStatusCallbackMethod != null) {
            request.addPostParam("RecordingStatusCallbackMethod", this.recordingStatusCallbackMethod.toString());
        }
        if (this.sendDigits != null) {
            request.addPostParam("SendDigits", this.sendDigits);
        }
        if (this.sipAuthPassword != null) {
            request.addPostParam("SipAuthPassword", this.sipAuthPassword);
        }
        if (this.sipAuthUsername != null) {
            request.addPostParam("SipAuthUsername", this.sipAuthUsername);
        }
        if (this.statusCallback != null) {
            request.addPostParam("StatusCallback", this.statusCallback.toString());
        }
        if (this.statusCallbackEvent != null) {
            for (String prop : this.statusCallbackEvent) {
                request.addPostParam("StatusCallbackEvent", prop);
            }
        }
        if (this.statusCallbackMethod != null) {
            request.addPostParam("StatusCallbackMethod", this.statusCallbackMethod.toString());
        }
        if (this.timeout != null) {
            request.addPostParam("Timeout", this.timeout.toString());
        }
        if (this.trim != null) {
            request.addPostParam("Trim", this.trim);
        }
        if (this.url != null) {
            request.addPostParam("Url", this.url.toString());
        }
    }
}

