/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.sync.service.synclist;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.sync.service.synclist.SyncListItemCreator;
import com.twilio.rest.preview.sync.service.synclist.SyncListItemDeleter;
import com.twilio.rest.preview.sync.service.synclist.SyncListItemFetcher;
import com.twilio.rest.preview.sync.service.synclist.SyncListItemReader;
import com.twilio.rest.preview.sync.service.synclist.SyncListItemUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SyncListItem
extends Resource {
    private static final long serialVersionUID = 211432738907618L;
    private final Integer index;
    private final String accountSid;
    private final String serviceSid;
    private final String listSid;
    private final URI url;
    private final String revision;
    private final Map<String, Object> data;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String createdBy;

    public static SyncListItemFetcher fetcher(String pathServiceSid, String pathListSid, Integer pathIndex) {
        return new SyncListItemFetcher(pathServiceSid, pathListSid, pathIndex);
    }

    public static SyncListItemDeleter deleter(String pathServiceSid, String pathListSid, Integer pathIndex) {
        return new SyncListItemDeleter(pathServiceSid, pathListSid, pathIndex);
    }

    public static SyncListItemCreator creator(String pathServiceSid, String pathListSid, Map<String, Object> data) {
        return new SyncListItemCreator(pathServiceSid, pathListSid, data);
    }

    public static SyncListItemReader reader(String pathServiceSid, String pathListSid) {
        return new SyncListItemReader(pathServiceSid, pathListSid);
    }

    public static SyncListItemUpdater updater(String pathServiceSid, String pathListSid, Integer pathIndex, Map<String, Object> data) {
        return new SyncListItemUpdater(pathServiceSid, pathListSid, pathIndex, data);
    }

    public static SyncListItem fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (SyncListItem)objectMapper.readValue(json, SyncListItem.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static SyncListItem fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (SyncListItem)objectMapper.readValue(json, SyncListItem.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private SyncListItem(@JsonProperty(value="index") Integer index, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="list_sid") String listSid, @JsonProperty(value="url") URI url, @JsonProperty(value="revision") String revision, @JsonProperty(value="data") Map<String, Object> data, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="created_by") String createdBy) {
        this.index = index;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.listSid = listSid;
        this.url = url;
        this.revision = revision;
        this.data = data;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.createdBy = createdBy;
    }

    public final Integer getIndex() {
        return this.index;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getListSid() {
        return this.listSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final String getRevision() {
        return this.revision;
    }

    public final Map<String, Object> getData() {
        return this.data;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getCreatedBy() {
        return this.createdBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyncListItem other = (SyncListItem)o;
        return Objects.equals(this.index, other.index) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.listSid, other.listSid) && Objects.equals(this.url, other.url) && Objects.equals(this.revision, other.revision) && Objects.equals(this.data, other.data) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.createdBy, other.createdBy);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.accountSid, this.serviceSid, this.listSid, this.url, this.revision, this.data, this.dateCreated, this.dateUpdated, this.createdBy);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("index", (Object)this.index).add("accountSid", (Object)this.accountSid).add("serviceSid", (Object)this.serviceSid).add("listSid", (Object)this.listSid).add("url", (Object)this.url).add("revision", (Object)this.revision).add("data", this.data).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("createdBy", (Object)this.createdBy).toString();
    }

    public static enum QueryFromBoundType {
        INCLUSIVE("inclusive"),
        EXCLUSIVE("exclusive");

        private final String value;

        private QueryFromBoundType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static QueryFromBoundType forValue(String value) {
            return (QueryFromBoundType)Promoter.enumFromString((String)value, (Enum[])QueryFromBoundType.values());
        }
    }

    public static enum QueryResultOrder {
        ASC("asc"),
        DESC("desc");

        private final String value;

        private QueryResultOrder(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static QueryResultOrder forValue(String value) {
            return (QueryResultOrder)Promoter.enumFromString((String)value, (Enum[])QueryResultOrder.values());
        }
    }
}

