/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.bulkExports;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.bulkExports.ExportConfigurationFetcher;
import com.twilio.rest.preview.bulkExports.ExportConfigurationUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ExportConfiguration
extends Resource {
    private static final long serialVersionUID = 121290827357040L;
    private final Boolean enabled;
    private final URI webhookUrl;
    private final String webhookMethod;
    private final String resourceType;
    private final URI url;

    public static ExportConfigurationFetcher fetcher(String pathResourceType) {
        return new ExportConfigurationFetcher(pathResourceType);
    }

    public static ExportConfigurationUpdater updater(String pathResourceType) {
        return new ExportConfigurationUpdater(pathResourceType);
    }

    public static ExportConfiguration fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (ExportConfiguration)objectMapper.readValue(json, ExportConfiguration.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ExportConfiguration fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (ExportConfiguration)objectMapper.readValue(json, ExportConfiguration.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ExportConfiguration(@JsonProperty(value="enabled") Boolean enabled, @JsonProperty(value="webhook_url") URI webhookUrl, @JsonProperty(value="webhook_method") String webhookMethod, @JsonProperty(value="resource_type") String resourceType, @JsonProperty(value="url") URI url) {
        this.enabled = enabled;
        this.webhookUrl = webhookUrl;
        this.webhookMethod = webhookMethod;
        this.resourceType = resourceType;
        this.url = url;
    }

    public final Boolean getEnabled() {
        return this.enabled;
    }

    public final URI getWebhookUrl() {
        return this.webhookUrl;
    }

    public final String getWebhookMethod() {
        return this.webhookMethod;
    }

    public final String getResourceType() {
        return this.resourceType;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExportConfiguration other = (ExportConfiguration)o;
        return Objects.equals(this.enabled, other.enabled) && Objects.equals(this.webhookUrl, other.webhookUrl) && Objects.equals(this.webhookMethod, other.webhookMethod) && Objects.equals(this.resourceType, other.resourceType) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.webhookUrl, this.webhookMethod, this.resourceType, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("enabled", (Object)this.enabled).add("webhookUrl", (Object)this.webhookUrl).add("webhookMethod", (Object)this.webhookMethod).add("resourceType", (Object)this.resourceType).add("url", (Object)this.url).toString();
    }
}

